/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationStrength;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.test.core.TestUtils;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class FindOptionsTest {
    private static JsonObject randomJsonObject() {
        JsonObject json = new JsonObject();
        json.put("string", (Object)TestUtils.randomAlphaString((int)10));
        json.put("int", (Object)TestUtils.randomInt());
        json.put("boolean", (Object)TestUtils.randomBoolean());
        return json;
    }

    @Test
    public void testOptions() {
        FindOptions options = new FindOptions();
        JsonObject fields = FindOptionsTest.randomJsonObject();
        Assert.assertEquals((Object)options, (Object)options.setFields(fields));
        Assert.assertEquals((Object)fields, (Object)options.getFields());
        JsonObject sort = FindOptionsTest.randomJsonObject();
        Assert.assertEquals((Object)options, (Object)options.setSort(sort));
        Assert.assertEquals((Object)sort, (Object)options.getSort());
        int limit = TestUtils.randomInt();
        Assert.assertEquals((Object)options, (Object)options.setLimit(limit));
        Assert.assertEquals((long)limit, (long)options.getLimit());
        int skip = TestUtils.randomInt();
        Assert.assertEquals((Object)options, (Object)options.setSkip(skip));
        Assert.assertEquals((long)skip, (long)options.getSkip());
        CollationOptions collationOptions = new CollationOptions();
        Assert.assertEquals((Object)options, (Object)options.setCollation(collationOptions));
        Assert.assertEquals((Object)collationOptions, (Object)options.getCollation());
    }

    @Test
    public void testDefaultOptions() {
        FindOptions options = new FindOptions();
        Assert.assertNotNull((Object)options.getFields());
        Assert.assertTrue((boolean)options.getFields().isEmpty());
        Assert.assertNotNull((Object)options.getSort());
        Assert.assertTrue((boolean)options.getSort().isEmpty());
        Assert.assertEquals((long)-1L, (long)options.getLimit());
        Assert.assertEquals((long)0L, (long)options.getSkip());
        Assert.assertNull((Object)options.getCollation());
    }

    @Test
    public void testOptionsJson() {
        JsonObject json = new JsonObject();
        JsonObject fields = FindOptionsTest.randomJsonObject();
        json.put("fields", (Object)fields);
        JsonObject sort = FindOptionsTest.randomJsonObject();
        json.put("sort", (Object)sort);
        int limit = TestUtils.randomInt();
        json.put("limit", (Object)limit);
        int skip = TestUtils.randomInt();
        json.put("skip", (Object)skip);
        JsonObject collationOptions = new JsonObject().put("locale", (Object)Locale.getDefault().toString()).put("caseLevel", (Object)true).put("caseFirst", (Object)"lower").put("alternate", (Object)"non-ignorable").put("strength", (Object)1).put("numericOrdering", (Object)true).put("maxVariable", (Object)"punct").put("backwards", (Object)false).put("normalization", (Object)true);
        json.put("collation", (Object)collationOptions);
        FindOptions options = new FindOptions(json);
        Assert.assertEquals((Object)fields, (Object)options.getFields());
        Assert.assertEquals((Object)sort, (Object)options.getSort());
        Assert.assertEquals((long)limit, (long)options.getLimit());
        Assert.assertEquals((long)skip, (long)options.getSkip());
        Assert.assertEquals((Object)collationOptions, (Object)options.getCollation().toJson());
    }

    @Test
    public void testDefaultOptionsJson() {
        FindOptions options = new FindOptions(new JsonObject());
        FindOptions def = new FindOptions();
        Assert.assertEquals((Object)def.getFields(), (Object)options.getFields());
        Assert.assertEquals((Object)def.getSort(), (Object)options.getSort());
        Assert.assertEquals((long)def.getLimit(), (long)options.getLimit());
        Assert.assertEquals((long)def.getSkip(), (long)options.getSkip());
        Assert.assertEquals((Object)def.getCollation(), (Object)options.getCollation());
    }

    @Test
    public void testCopyOptions() {
        FindOptions options = new FindOptions();
        JsonObject fields = FindOptionsTest.randomJsonObject();
        JsonObject sort = FindOptionsTest.randomJsonObject();
        int limit = TestUtils.randomInt();
        int skip = TestUtils.randomInt();
        CollationOptions collationOptions = new CollationOptions().setStrength(CollationStrength.PRIMARY);
        options.setFields(fields);
        options.setSort(sort);
        options.setLimit(limit);
        options.setSkip(skip);
        options.setCollation(collationOptions);
        FindOptions copy = new FindOptions(options);
        Assert.assertEquals((Object)options.getFields(), (Object)copy.getFields());
        Assert.assertEquals((Object)options.getSort(), (Object)copy.getSort());
        Assert.assertEquals((long)options.getLimit(), (long)copy.getLimit());
        Assert.assertEquals((long)options.getSkip(), (long)copy.getSkip());
        Assert.assertEquals((Object)options.getCollation(), (Object)copy.getCollation());
    }

    @Test
    public void testToJson() {
        FindOptions options = new FindOptions();
        JsonObject fields = FindOptionsTest.randomJsonObject();
        JsonObject sort = FindOptionsTest.randomJsonObject();
        int limit = TestUtils.randomPositiveInt();
        int skip = TestUtils.randomPositiveInt();
        CollationOptions collationOptions = new CollationOptions().setStrength(CollationStrength.PRIMARY);
        options.setFields(fields);
        options.setSort(sort);
        options.setLimit(limit);
        options.setSkip(skip);
        options.setCollation(collationOptions);
        Assert.assertEquals((Object)options, (Object)new FindOptions(options.toJson()));
    }
}

