/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.TimeSeriesGranularity;
import io.vertx.ext.mongo.TimeSeriesOptions;
import io.vertx.ext.mongo.ValidationOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class CreateCollectionOptionsTest {
    private static void assertNotEqual(BiConsumer<CreateCollectionOptions, CreateCollectionOptions> f) {
        CreateCollectionOptions a = new CreateCollectionOptions();
        CreateCollectionOptions b = new CreateCollectionOptions();
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<CreateCollectionOptions> f) {
        CreateCollectionOptions o = new CreateCollectionOptions();
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new CreateCollectionOptions(), (Object)new CreateCollectionOptions());
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setCapped(Boolean.valueOf(true));
            b.setCapped(Boolean.valueOf(false));
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setCollation(new CollationOptions().setLocale("de_AT"));
            b.setCollation(new CollationOptions().setLocale("en_US"));
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setIndexOptionDefaults(new JsonObject().put("some", (Object)"option"));
            b.setIndexOptionDefaults(new JsonObject());
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setValidationOptions(new ValidationOptions().setValidationAction(ValidationAction.WARN));
            b.setValidationOptions(new ValidationOptions().setValidationAction(ValidationAction.ERROR));
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setMaxDocuments(Long.valueOf(12345L));
            b.setMaxDocuments(Long.valueOf(10L));
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setSizeInBytes(Long.valueOf(1024L));
            b.setSizeInBytes(Long.valueOf(2048L));
        });
        CreateCollectionOptionsTest.assertNotEqual((a, b) -> {
            a.setStorageEngineOptions(new JsonObject().put("some", (Object)"option"));
            b.setStorageEngineOptions(new JsonObject());
        });
        Assert.assertNotEquals((Object)new CreateCollectionOptions(), null);
    }

    @Test
    public void testHashCode() {
        CreateCollectionOptions a = new CreateCollectionOptions();
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new CreateCollectionOptions().hashCode());
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setMaxDocuments(Long.valueOf(12345L)));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setSizeInBytes(Long.valueOf(4096L)));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setCapped(Boolean.valueOf(true)));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setValidationOptions(new ValidationOptions().setValidationLevel(ValidationLevel.MODERATE)));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setIndexOptionDefaults(new JsonObject().put("some", (Object)"option")));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setCollation(new CollationOptions().setLocale("de_AT").setStrength(CollationStrength.IDENTICAL)));
        CreateCollectionOptionsTest.assertNotEqual(hash, o -> o.setStorageEngineOptions(new JsonObject().put("some", (Object)"option")));
    }

    @Test
    public void testCreateCollectionOptionsFromJson() {
        JsonObject json = new JsonObject().put("maxDocuments", (Object)10L).put("sizeInBytes", (Object)20L).put("capped", (Object)true).put("validationOptions", (Object)new JsonObject().put("validationLevel", (Object)"STRICT").put("validationAction", (Object)"ERROR")).put("indexOptionDefaults", (Object)new JsonObject().put("some", (Object)"value")).put("storageEngineOptions", (Object)new JsonObject().put("some", (Object)"otherValue")).put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        CreateCollectionOptions options = new CreateCollectionOptions(json);
        Assert.assertEquals((Object)new ValidationOptions().setValidationLevel(ValidationLevel.STRICT).setValidationAction(ValidationAction.ERROR), (Object)options.getValidationOptions());
        Assert.assertEquals((Object)new JsonObject().put("some", (Object)"value"), (Object)options.getIndexOptionDefaults());
        Assert.assertEquals((Object)new JsonObject().put("some", (Object)"otherValue"), (Object)options.getStorageEngineOptions());
        Assert.assertEquals((Object)true, (Object)options.getCapped());
        Assert.assertEquals((Object)10L, (Object)options.getMaxDocuments());
        Assert.assertEquals((Object)20L, (Object)options.getSizeInBytes());
        Assert.assertEquals((Object)new CollationOptions(), (Object)options.getCollation());
    }

    @Test
    public void testCreateCollectionOptionsToJson() {
        JsonObject json = new JsonObject().put("maxDocuments", (Object)10L).put("sizeInBytes", (Object)20L).put("capped", (Object)true).put("validationOptions", (Object)new JsonObject().put("validationLevel", (Object)"STRICT").put("validationAction", (Object)"ERROR").put("validator", (Object)new JsonObject())).put("indexOptionDefaults", (Object)new JsonObject().put("some", (Object)"value")).put("storageEngineOptions", (Object)new JsonObject().put("some", (Object)"otherValue")).put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        CreateCollectionOptions options = new CreateCollectionOptions().setCollation(new CollationOptions()).setMaxDocuments(Long.valueOf(10L)).setSizeInBytes(Long.valueOf(20L)).setValidationOptions(new ValidationOptions().setValidationLevel(ValidationLevel.STRICT).setValidationAction(ValidationAction.ERROR)).setStorageEngineOptions(new JsonObject().put("some", (Object)"otherValue")).setIndexOptionDefaults(new JsonObject().put("some", (Object)"value")).setCapped(Boolean.valueOf(true));
        Assert.assertEquals((Object)json, (Object)options.toJson());
    }

    @Test
    public void testSetTimeSeries() {
        TimeSeriesOptions timeseries = new TimeSeriesOptions().setTimeField("time");
        CreateCollectionOptions options = new CreateCollectionOptions();
        options.setTimeSeriesOptions(timeseries);
        Assert.assertEquals((Object)"time", (Object)options.toMongoDriverObject().getTimeSeriesOptions().getTimeField());
        timeseries.setMetaField("meta");
        options.setTimeSeriesOptions(timeseries);
        Assert.assertEquals((Object)"meta", (Object)options.toMongoDriverObject().getTimeSeriesOptions().getMetaField());
        timeseries.setGranularity(TimeSeriesGranularity.MINUTES);
        options.setTimeSeriesOptions(timeseries);
        Assert.assertEquals((Object)com.mongodb.client.model.TimeSeriesGranularity.MINUTES, (Object)options.toMongoDriverObject().getTimeSeriesOptions().getGranularity());
        timeseries.setGranularity(TimeSeriesGranularity.SECONDS);
        options.setTimeSeriesOptions(timeseries);
        Assert.assertEquals((Object)com.mongodb.client.model.TimeSeriesGranularity.SECONDS, (Object)options.toMongoDriverObject().getTimeSeriesOptions().getGranularity());
    }
}

