/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoTestBase;
import io.vertx.ext.mongo.WriteOption;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class CompressorsConnectivityTest
extends MongoTestBase {
    private MongoClient mongoClient;

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = CompressorsConnectivityTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        super.tearDown();
    }

    @Test
    public void testQueryWithZLibCompressOptions() {
        JsonObject config = CompressorsConnectivityTest.getConfig().put("compressors", (Object)new JsonArray().add((Object)"zlib")).put("zlibCompressionLevel", (Object)6);
        MongoClient mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        String collection = this.randomCollection();
        mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = new JsonObject().put("compressor", (Object)"zlib");
            mongoClient.insertWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> mongoClient.find(collection, new JsonObject(), this.onSuccess(r -> {
                this.assertEquals("zlib", ((JsonObject)r.get(0)).getString("compressor"));
                this.testComplete();
            }))));
        }));
        this.await();
    }
}

