/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientTestBase;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Test;

public class CloseTest
extends MongoClientTestBase {
    private static final JsonObject theConfig = CloseTest.getConfig();

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = CloseTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    @Test
    public void testCloseWhenVerticleUndeployed() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(SharedVerticle.class.getName(), new DeploymentOptions().setInstances(1), this.onSuccess(id::complete));
        this.close((String)id.get(10L, TimeUnit.SECONDS));
    }

    private void close(String deploymentId) throws InterruptedException {
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.vertx.undeploy(deploymentId, this.onSuccess(v -> closeLatch.countDown()));
        this.awaitLatch(closeLatch);
    }

    public static class SharedVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> startFuture) {
            MongoClient client = MongoClient.create((Vertx)this.vertx, (JsonObject)theConfig);
            startFuture.complete();
        }
    }
}

