/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

class VertxNetClientMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> connections;
    private final Counters bytesReceived;
    private final Counters bytesSent;
    private final Counters errorCount;

    VertxNetClientMetrics(MeterRegistry registry, MetricsNaming names, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        this(registry, MetricsDomain.NET_CLIENT, names, gaugesTable);
    }

    VertxNetClientMetrics(MeterRegistry registry, MetricsDomain domain, MetricsNaming names, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, domain, gaugesTable);
        this.connections = this.longGauges(names.getNetActiveConnections(), "Number of connections to the remote host currently opened", Label.LOCAL, Label.REMOTE);
        this.bytesReceived = this.counters(names.getNetBytesRead(), "Number of bytes received from the remote host", Label.LOCAL, Label.REMOTE);
        this.bytesSent = this.counters(names.getNetBytesWritten(), "Number of bytes sent to the remote host", Label.LOCAL, Label.REMOTE);
        this.errorCount = this.counters(names.getNetErrorCount(), "Number of errors", Label.LOCAL, Label.REMOTE, Label.CLASS_NAME);
    }

    TCPMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    class Instance
    implements MicrometerMetrics,
    TCPMetrics<String> {
        protected final String local;

        Instance(String localAddress) {
            this.local = localAddress == null ? "?" : localAddress;
        }

        public String connected(SocketAddress remoteAddress, String remoteName) {
            String remote = Labels.address(remoteAddress, remoteName);
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote, SocketAddress remoteAddress) {
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).decrement();
        }

        public void bytesRead(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesReceived.get(this.local, remote).increment((double)numberOfBytes);
        }

        public void bytesWritten(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesSent.get(this.local, remote).increment((double)numberOfBytes);
        }

        public void exceptionOccurred(String remote, SocketAddress remoteAddress, Throwable t) {
            VertxNetClientMetrics.this.errorCount.get(this.local, remote, t.getClass().getSimpleName()).increment();
        }

        public void close() {
        }

        @Override
        public MeterRegistry registry() {
            return VertxNetClientMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxNetClientMetrics.this.baseName();
        }
    }
}

