/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.VertxNetServerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

class VertxHttpServerMetrics
extends VertxNetServerMetrics {
    private final Gauges<LongAdder> requests;
    private final Counters requestCount;
    private final Counters requestResetCount;
    private final Summaries requestBytes;
    private final Timers processingTime;
    private final Summaries responseBytes;
    private final Gauges<LongAdder> wsConnections;
    private final Function<HttpRequest, Iterable<Tag>> customTagsProvider;

    VertxHttpServerMetrics(MeterRegistry registry, MetricsNaming names, Function<HttpRequest, Iterable<Tag>> customTagsProvider, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, MetricsDomain.HTTP_SERVER, names, gaugesTable);
        this.customTagsProvider = customTagsProvider;
        this.requests = this.longGauges(names.getHttpActiveRequests(), "Number of requests being processed", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.requestCount = this.counters(names.getHttpRequestsCount(), "Number of processed requests", Label.LOCAL, Label.REMOTE, Label.HTTP_ROUTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.requestResetCount = this.counters(names.getHttpRequestResetsCount(), "Number of request resets", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.requestBytes = this.summaries(names.getHttpRequestBytes(), "Size of requests in bytes", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.processingTime = this.timers(names.getHttpResponseTime(), "Request processing time", Label.LOCAL, Label.REMOTE, Label.HTTP_ROUTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.responseBytes = this.summaries(names.getHttpResponseBytes(), "Size of responses in bytes", Label.LOCAL, Label.REMOTE, Label.HTTP_ROUTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.wsConnections = this.longGauges(names.getHttpActiveWsConnections(), "Number of websockets currently opened", Label.LOCAL, Label.REMOTE);
    }

    HttpServerMetrics forAddress(SocketAddress localAddress) {
        return new Instance(Labels.address(localAddress));
    }

    public static class Handler {
        private final String address;
        private final String path;
        private final String method;
        private Object routes;
        private int routesLength;
        private Timers.EventTiming timer;
        private Iterable<Tag> customTags;
        private boolean responseEnded;
        private boolean requestEnded;
        private boolean reset;

        Handler(String address, String path, String method) {
            this.address = address;
            this.path = path;
            this.method = method;
        }

        private void addRoute(String route) {
            if (route == null) {
                return;
            }
            this.routesLength += route.length();
            if (this.routes == null) {
                this.routes = route;
                return;
            }
            ++this.routesLength;
            if (this.routes instanceof List) {
                ((List)this.routes).add(route);
                return;
            }
            LinkedList<String> multipleRoutes = new LinkedList<String>();
            multipleRoutes.add((String)this.routes);
            multipleRoutes.add(route);
            this.routes = multipleRoutes;
        }

        private String getRoute() {
            if (this.routes == null) {
                return "";
            }
            if (this.routes instanceof String) {
                return (String)this.routes;
            }
            StringBuilder concatenation = new StringBuilder(this.routesLength);
            Iterator iterator = ((List)this.routes).iterator();
            concatenation.append((String)iterator.next());
            while (iterator.hasNext()) {
                concatenation.append('>').append((String)iterator.next());
            }
            this.routes = concatenation.toString();
            return (String)this.routes;
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }
    }

    class Instance
    extends VertxNetServerMetrics.Instance
    implements HttpServerMetrics<Handler, String, String> {
        Instance(String local) {
            super(local);
        }

        public Handler requestBegin(String remote, HttpRequest request) {
            Handler handler = new Handler(remote, request.uri(), request.method().name());
            if (VertxHttpServerMetrics.this.customTagsProvider != null) {
                handler.customTags = (Iterable)VertxHttpServerMetrics.this.customTagsProvider.apply(request);
            }
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(handler.customTags, this.local, remote, handler.path, handler.method)).increment();
            handler.timer = VertxHttpServerMetrics.this.processingTime.start();
            return handler;
        }

        public void requestReset(Handler handler) {
            VertxHttpServerMetrics.this.requestResetCount.get(handler.customTags, this.local, handler.address, handler.path, handler.method).increment();
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(handler.customTags, this.local, handler.address, handler.path, handler.method)).decrement();
            handler.requestReset();
        }

        public void requestEnd(Handler handler, HttpRequest request, long bytesRead) {
            VertxHttpServerMetrics.this.requestBytes.get(handler.customTags, this.local, handler.address, handler.path, handler.method).record((double)bytesRead);
            if (handler.requestEnded()) {
                ((LongAdder)VertxHttpServerMetrics.this.requests.get(handler.customTags, this.local, handler.address, handler.path, handler.method)).decrement();
            }
        }

        public Handler responsePushed(String remote, HttpMethod method, String uri, HttpResponse response) {
            Handler handler = new Handler(remote, uri, method.name());
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(handler.customTags, this.local, remote, handler.path, handler.method)).increment();
            return handler;
        }

        public void responseBegin(Handler handler, HttpResponse response) {
        }

        public void responseEnd(Handler handler, HttpResponse response, long bytesWritten) {
            String code = String.valueOf(response.statusCode());
            String handlerRoute = handler.getRoute();
            handler.timer.end(handler.customTags, this.local, handler.address, handlerRoute, handler.path, handler.method, code);
            VertxHttpServerMetrics.this.requestCount.get(handler.customTags, this.local, handler.address, handlerRoute, handler.path, handler.method, code).increment();
            VertxHttpServerMetrics.this.responseBytes.get(handler.customTags, this.local, handler.address, handlerRoute, handler.path, handler.method, code).record((double)bytesWritten);
            if (handler.responseEnded()) {
                ((LongAdder)VertxHttpServerMetrics.this.requests.get(handler.customTags, this.local, handler.address, handler.path, handler.method)).decrement();
            }
        }

        public String connected(String socketMetric, Handler handler, ServerWebSocket serverWebSocket) {
            ((LongAdder)VertxHttpServerMetrics.this.wsConnections.get(this.local, handler.address)).increment();
            return handler.address;
        }

        public void disconnected(String remote) {
            ((LongAdder)VertxHttpServerMetrics.this.wsConnections.get(this.local, remote)).decrement();
        }

        public void requestRouted(Handler handler, String route) {
            handler.addRoute(route);
        }

        @Override
        public void close() {
        }
    }
}

