/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.micrometer.Label;
import java.util.Arrays;

public final class Labels {
    private Labels() {
    }

    static String address(SocketAddress address) {
        return Labels.address(address, null);
    }

    static String address(SocketAddress address, String nameOverride) {
        if (address == null) {
            return "?";
        }
        if (nameOverride == null) {
            return address.toString();
        }
        SocketAddress addrOverride = address.port() >= 0 ? SocketAddress.inetSocketAddress((int)address.port(), (String)nameOverride) : SocketAddress.domainSocketAddress((String)nameOverride);
        return addrOverride.toString();
    }

    static String getSide(boolean local) {
        return local ? "local" : "remote";
    }

    public static Tags toTags(Label[] keys, String[] values) {
        if (keys.length == 0) {
            return Tags.empty();
        }
        String[] keyValuePairs = new String[2 * keys.length];
        int count = 0;
        for (int i = 0; i < keys.length; ++i) {
            String lowKey;
            String value = values[i];
            if (value == null) continue;
            keyValuePairs[2 * count] = lowKey = keys[i].toString();
            keyValuePairs[2 * count + 1] = value;
            ++count;
        }
        if (count == 0) {
            return Tags.empty();
        }
        if (count == keys.length) {
            return Tags.of((String[])keyValuePairs);
        }
        return Tags.of((String[])Arrays.copyOf(keyValuePairs, 2 * count));
    }
}

