/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.VertxGen;

@VertxGen
public enum DKIMSignAlgorithm {
    RSA_SHA1("sha1", "rsa", "SHA-1"),
    RSA_SHA256("sha256", "rsa", "SHA-256");

    private final String hashAlgoId;
    private final String type;
    private final String hashAlgo;

    private DKIMSignAlgorithm(String hashAlgoId, String type, String hashAlgo) {
        this.hashAlgoId = hashAlgoId;
        this.type = type;
        this.hashAlgo = hashAlgo;
    }

    public String dkimAlgoName() {
        return this.type + "-" + this.hashAlgoId;
    }

    public String hashAlgorithm() {
        return this.hashAlgo;
    }

    public String hashAlgoId() {
        return this.hashAlgoId;
    }

    public String signatureAlgorithm() {
        return this.hashAlgoId.toUpperCase() + "with" + this.type.toUpperCase();
    }
}

