require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.BodyHandler
module VertxWeb
  #  A handler which gathers the entire request body and sets it on the .
  #  <p>
  #  It also handles HTTP file uploads and can be used to limit body sizes.
  class BodyHandler
    # @private
    # @param j_del [::VertxWeb::BodyHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::BodyHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BodyHandler
    end
    def @@j_api_type.wrap(obj)
      BodyHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::BodyHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Create a body handler and use the given upload directory.
    # @overload create()
    # @overload create(handleFileUploads)
    #   @param [true,false] handleFileUploads true if files upload should be handled
    # @overload create(uploadDirectory)
    #   @param [String] uploadDirectory the uploads directory
    # @return [::VertxWeb::BodyHandler] the body handler
    def self.create(param_1=nil)
      if !block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, []).call(),::VertxWeb::BodyHandler)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, [Java::boolean.java_class]).call(param_1),::VertxWeb::BodyHandler)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, [Java::java.lang.String.java_class]).call(param_1),::VertxWeb::BodyHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1})"
    end
    #  Set whether file uploads will be handled
    # @param [true,false] handleFileUploads true if they should be handled
    # @return [self]
    def set_handle_file_uploads(handleFileUploads=nil)
      if (handleFileUploads.class == TrueClass || handleFileUploads.class == FalseClass) && !block_given?
        @j_del.java_method(:setHandleFileUploads, [Java::boolean.java_class]).call(handleFileUploads)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_handle_file_uploads(#{handleFileUploads})"
    end
    #  Set the maximum body size in bytes, <code>-1</code> means no limit
    # @param [Fixnum] bodyLimit the max size in bytes
    # @return [self]
    def set_body_limit(bodyLimit=nil)
      if bodyLimit.class == Fixnum && !block_given?
        @j_del.java_method(:setBodyLimit, [Java::long.java_class]).call(bodyLimit)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_body_limit(#{bodyLimit})"
    end
    #  Set the uploads directory to use
    # @param [String] uploadsDirectory the uploads directory
    # @return [self]
    def set_uploads_directory(uploadsDirectory=nil)
      if uploadsDirectory.class == String && !block_given?
        @j_del.java_method(:setUploadsDirectory, [Java::java.lang.String.java_class]).call(uploadsDirectory)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_uploads_directory(#{uploadsDirectory})"
    end
    #  Set whether form attributes will be added to the request parameters
    # @param [true,false] mergeFormAttributes true if they should be merged
    # @return [self]
    def set_merge_form_attributes(mergeFormAttributes=nil)
      if (mergeFormAttributes.class == TrueClass || mergeFormAttributes.class == FalseClass) && !block_given?
        @j_del.java_method(:setMergeFormAttributes, [Java::boolean.java_class]).call(mergeFormAttributes)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_merge_form_attributes(#{mergeFormAttributes})"
    end
    #  Set whether uploaded files should be removed after handling the request
    # @param [true,false] deleteUploadedFilesOnEnd true if uploaded files should be removed after handling the request
    # @return [self]
    def set_delete_uploaded_files_on_end(deleteUploadedFilesOnEnd=nil)
      if (deleteUploadedFilesOnEnd.class == TrueClass || deleteUploadedFilesOnEnd.class == FalseClass) && !block_given?
        @j_del.java_method(:setDeleteUploadedFilesOnEnd, [Java::boolean.java_class]).call(deleteUploadedFilesOnEnd)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_delete_uploaded_files_on_end(#{deleteUploadedFilesOnEnd})"
    end
    #  Pre-allocate the body buffer according to the value parsed from content-length header.
    #  The buffer is capped at 64KB
    # @param [true,false] isPreallocateBodyBuffer <code>true</code> if body buffer is pre-allocated according to the size read from content-length Header. {code false} if body buffer is pre-allocated to 1KB, and is resized dynamically
    # @return [self]
    def set_preallocate_body_buffer(isPreallocateBodyBuffer=nil)
      if (isPreallocateBodyBuffer.class == TrueClass || isPreallocateBodyBuffer.class == FalseClass) && !block_given?
        @j_del.java_method(:setPreallocateBodyBuffer, [Java::boolean.java_class]).call(isPreallocateBodyBuffer)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_preallocate_body_buffer(#{isPreallocateBodyBuffer})"
    end
    #  Default max size for a request body = <code>-1</code> means unlimited
    def self.DEFAULT_BODY_LIMIT
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_BODY_LIMIT
    end
    #  Default uploads directory on server for file uploads
    def self.DEFAULT_UPLOADS_DIRECTORY
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_UPLOADS_DIRECTORY
    end
    #  Default value of whether form attributes should be merged into request params
    def self.DEFAULT_MERGE_FORM_ATTRIBUTES
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_MERGE_FORM_ATTRIBUTES
    end
    #  Default value of whether uploaded files should be removed after handling the request
    def self.DEFAULT_DELETE_UPLOADED_FILES_ON_END
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_DELETE_UPLOADED_FILES_ON_END
    end
    #  Default value of whether to pre-allocate the body buffer size according to the content-length HTTP request header
    def self.DEFAULT_PREALLOCATE_BODY_BUFFER
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_PREALLOCATE_BODY_BUFFER
    end
  end
end
