require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.SqlClient
module VertxSqlClient
  #  Defines the client operations with a database server.
  class SqlClient
    # @private
    # @param j_del [::VertxSqlClient::SqlClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::SqlClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SqlClient
    end
    def @@j_api_type.wrap(obj)
      SqlClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::SqlClient.java_class
    end
    #  Create a query, the {::VertxSqlClient::Query#execute} method must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query] the query
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Create a prepared query, one of the {::VertxSqlClient::Query#execute} or {::VertxSqlClient::PreparedQuery#execute_batch}
    #  methods must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery] the prepared query
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Close the client and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
