require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Query
module VertxSqlClient
  #  A query.
  class Query
    # @private
    # @param j_del [::VertxSqlClient::Query] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxSqlClient::Query] the underlying java delegate
    def j_del
      @j_del
    end
    #  Execute the query.
    # @yield the handler receiving the response
    # @return [void]
    def execute
      if block_given?
        return @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling execute()"
    end
    #  Use the specified <code>mapper</code> for mapping {::VertxSqlClient::Row} to <code><U></code>.
    # @yield 
    # @return [::VertxSqlClient::Query]
    def mapping(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapping, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::VertxSqlClient::Row))) })),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling mapping(#{mapper})"
    end
  end
end
