require 'vertx-rabbitmq/envelope'
require 'vertx/buffer'
require 'vertx-rabbitmq/basic_properties'
require 'vertx/util/utils.rb'
# Generated from io.vertx.rabbitmq.RabbitMQMessage
module VertxRabbitmq
  #  Represent a message received message received in a rabbitmq-queue.
  class RabbitMQMessage
    # @private
    # @param j_del [::VertxRabbitmq::RabbitMQMessage] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRabbitmq::RabbitMQMessage] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RabbitMQMessage
    end
    def @@j_api_type.wrap(obj)
      RabbitMQMessage.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRabbitmq::RabbitMQMessage.java_class
    end
    # @return [::Vertx::Buffer] the message body
    def body
      if !block_given?
        if @cached_body != nil
          return @cached_body
        end
        return @cached_body = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:body, []).call(),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling body()"
    end
    # @return [String] the <i>consumer tag</i> associated with the consumer
    def consumer_tag
      if !block_given?
        if @cached_consumer_tag != nil
          return @cached_consumer_tag
        end
        return @cached_consumer_tag = @j_del.java_method(:consumerTag, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling consumer_tag()"
    end
    # @return [::VertxRabbitmq::Envelope] packaging data for the message
    def envelope
      if !block_given?
        if @cached_envelope != nil
          return @cached_envelope
        end
        return @cached_envelope = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:envelope, []).call(),::VertxRabbitmq::Envelope)
      end
      raise ArgumentError, "Invalid arguments when calling envelope()"
    end
    # @return [::VertxRabbitmq::BasicProperties] content header data for the message
    def properties
      if !block_given?
        if @cached_properties != nil
          return @cached_properties
        end
        return @cached_properties = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:properties, []).call(),::VertxRabbitmq::BasicProperties)
      end
      raise ArgumentError, "Invalid arguments when calling properties()"
    end
  end
end
