require 'vertx-sql-client/sql_connection'
require 'vertx-sql-client/query'
require 'vertx/vertx'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/database_metadata'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/prepared_statement'
require 'vertx/util/utils.rb'
# Generated from io.vertx.db2client.DB2Connection
module VertxDb2Client
  #  A connection to DB2 server.
  class DB2Connection < ::VertxSqlClient::SqlConnection
    # @private
    # @param j_del [::VertxDb2Client::DB2Connection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxDb2Client::DB2Connection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DB2Connection
    end
    def @@j_api_type.wrap(obj)
      DB2Connection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxDb2client::DB2Connection.java_class
    end
    #  Create a query, the  method must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query] the query
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Create a prepared query, one of the  or 
    #  methods must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery] the prepared query
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Begin a transaction and returns a  for controlling and tracking
    #  this transaction.
    #  <p/>
    #  When the connection is explicitely closed, any inflight transaction is rollbacked.
    # @return [::VertxSqlClient::Transaction] the transaction instance
    def begin
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:begin, []).call(),::VertxSqlClient::Transaction)
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    # @return [true,false] whether the connection uses SSL
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSSL, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    #  Close the current connection after all the pending commands have been processed.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    # @return [::VertxSqlClient::DatabaseMetadata] The static metadata about the backend database server for this connection
    def database_metadata
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:databaseMetadata, []).call(),::VertxSqlClient::DatabaseMetadata)
      end
      raise ArgumentError, "Invalid arguments when calling database_metadata()"
    end
    #  Like {::VertxDb2Client::DB2Connection#connect} with options build
    #  from <code>connectionUri</code>.
    # @overload connect(vertx,connectOptions,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash] connectOptions the options for the connection
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(param_1=nil,param_2=nil)
      if param_1.class.method_defined?(:j_del) && param_2.class == Hash && block_given?
        return Java::IoVertxDb2client::DB2Connection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxDb2client::DB2ConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,Java::IoVertxDb2client::DB2ConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxDb2Client::DB2Connection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && block_given?
        return Java::IoVertxDb2client::DB2Connection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxDb2Client::DB2Connection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{param_1},#{param_2})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedStatement) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    #  Send a PING command to check if the server is alive.
    # @yield the handler notified when the server responses to client
    # @return [self]
    def ping
      if block_given?
        @j_del.java_method(:ping, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ping()"
    end
    #  Send a DEBUG command to dump debug information to the server's stdout.
    # @yield the handler notified with the execution result
    # @return [self]
    def debug
      if block_given?
        @j_del.java_method(:debug, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling debug()"
    end
  end
end
