/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.httpservicefactory;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class PGPHelper {
    public static PGPSignature getSignature(byte[] signature) throws Exception {
        InputStream in = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(signature));
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPSignatureList sigList = (PGPSignatureList)pgpObjectFactory.nextObject();
        return sigList.get(0);
    }

    public static PGPPublicKey getPublicKey(byte[] block, long keyID) throws Exception {
        InputStream keyIn = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(block));
        PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(keyIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        return pgpRing.getPublicKey(keyID);
    }

    public static boolean verifySignature(InputStream file, InputStream signature, PGPPublicKey key) throws Exception {
        InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)signature);
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPSignatureList sigList = (PGPSignatureList)pgpObjectFactory.nextObject();
        PGPSignature pgpSignature = sigList.get(0);
        pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), key);
        try (BufferedInputStream inArtifact = new BufferedInputStream(file);){
            int t;
            while ((t = ((InputStream)inArtifact).read()) >= 0) {
                pgpSignature.update((byte)t);
            }
        }
        return pgpSignature.verify();
    }
}

