/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class Throttling {
    private final Consumer<String> action;
    private final ScheduledExecutorService executorService;
    private final ConcurrentMap<String, State> map;
    private final AtomicInteger counter;
    private final Object condition;

    public Throttling(Consumer<String> action) {
        this.action = action;
        this.executorService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "vertx-hazelcast-service-throttling-thread");
            thread.setDaemon(true);
            return thread;
        });
        this.map = new ConcurrentHashMap<String, State>();
        this.counter = new AtomicInteger();
        this.condition = new Object();
    }

    public void onEvent(String address) {
        if (!this.tryIncrementCounter()) {
            return;
        }
        State curr = this.map.compute(address, (s, state) -> state == null ? State.NEW : state.pending());
        if (curr == State.NEW) {
            this.executorService.execute(() -> this.run(address));
        } else {
            this.decrementCounter();
        }
    }

    private void run(String address) {
        this.map.computeIfPresent(address, (s, state) -> state.start());
        try {
            this.action.accept(address);
        }
        finally {
            this.map.computeIfPresent(address, (s, state) -> state.done());
            this.executorService.schedule(() -> this.checkState(address), 20L, TimeUnit.MILLISECONDS);
        }
    }

    private void checkState(String address) {
        State curr = this.map.computeIfPresent(address, (s, state) -> state.next());
        if (curr == State.NEW) {
            this.run(address);
        } else {
            this.decrementCounter();
        }
    }

    private boolean tryIncrementCounter() {
        int i;
        do {
            if ((i = this.counter.get()) >= 0) continue;
            return false;
        } while (!this.counter.compareAndSet(i, i + 1));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCounter() {
        if (this.counter.decrementAndGet() < 0) {
            Object object = this.condition;
            synchronized (object) {
                this.condition.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.condition;
        synchronized (object) {
            int i = this.counter.getAndSet(-1);
            if (i == 0) {
                return;
            }
            boolean interrupted = false;
            do {
                try {
                    this.condition.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (this.counter.get() != -(i + 1));
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static enum State {
        NEW{

            @Override
            State pending() {
                return PENDING;
            }

            @Override
            State start() {
                return RUNNING;
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                return RUNNING;
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        RUNNING{

            @Override
            State pending() {
                return RUNNING_PENDING;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                return FINISHED;
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        RUNNING_PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                return FINISHED_PENDING;
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        FINISHED{

            @Override
            State pending() {
                return FINISHED_PENDING;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                return null;
            }
        }
        ,
        FINISHED_PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                return NEW;
            }
        };


        abstract State pending();

        abstract State start();

        abstract State done();

        abstract State next();
    }
}

