/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.map.IMap;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastServerID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public class HazelcastAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final VertxInternal vertx;
    private final IMap<K, V> map;

    public HazelcastAsyncMap(VertxInternal vertx, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    public Future<V> get(K k) {
        K kk = ConversionUtils.convertParam(k);
        ContextInternal context = this.vertx.getOrCreateContext();
        return Future.fromCompletionStage((CompletionStage)this.map.getAsync(kk), (Context)context).map(ConversionUtils::convertReturn);
    }

    public Future<Void> put(K k, V v) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        ContextInternal context = this.vertx.getOrCreateContext();
        return Future.fromCompletionStage((CompletionStage)this.map.setAsync(kk, HazelcastServerID.convertServerID(vv)), (Context)context);
    }

    public Future<V> putIfAbsent(K k, V v) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        return this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv)))), false);
    }

    public Future<Void> put(K k, V v, long ttl) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        ContextInternal context = this.vertx.getOrCreateContext();
        CompletionStage completionStage = this.map.setAsync(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)context);
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        return this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS))), false);
    }

    public Future<V> remove(K k) {
        K kk = ConversionUtils.convertParam(k);
        ContextInternal context = this.vertx.getOrCreateContext();
        CompletionStage completionStage = this.map.removeAsync(kk);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)context).map(ConversionUtils::convertReturn);
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        return this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.remove(kk, vv)), false);
    }

    public Future<V> replace(K k, V v) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        return this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.replace(kk, vv))), false);
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(oldValue);
        V vvv = ConversionUtils.convertParam(newValue);
        return this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.replace(kk, vv, vvv)), false);
    }

    public Future<Void> clear() {
        return this.vertx.executeBlocking(fut -> {
            this.map.clear();
            fut.complete();
        }, false);
    }

    public Future<Integer> size() {
        return this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.size()), false);
    }

    public Future<Set<K>> keys() {
        return this.vertx.executeBlocking(fut -> {
            HashSet set = new HashSet();
            for (Object kk : this.map.keySet()) {
                Object k = ConversionUtils.convertReturn(kk);
                set.add(k);
            }
            fut.complete(set);
        }, false);
    }

    public Future<List<V>> values() {
        return this.vertx.executeBlocking(fut -> {
            ArrayList list = new ArrayList();
            for (Object vv : this.map.values()) {
                Object v = ConversionUtils.convertReturn(vv);
                list.add(v);
            }
            fut.complete(list);
        }, false);
    }

    public Future<Map<K, V>> entries() {
        return this.vertx.executeBlocking(fut -> {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.map.entrySet()) {
                Object k = ConversionUtils.convertReturn(entry.getKey());
                Object v = ConversionUtils.convertReturn(entry.getValue());
                result.put(k, v);
            }
            fut.complete(result);
        }, false);
    }
}

