/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.vertx.codegen.annotations.DataObject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DataObject
public class GrpcClientOptions {
    public static final boolean DEFAULT_SCHEDULE_DEADLINE_AUTOMATICALLY = false;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final long DEFAULT_MAX_MESSAGE_SIZE = 262144L;
    private boolean scheduleDeadlineAutomatically;
    private int timeout;
    private TimeUnit timeoutUnit;
    private long maxMessageSize;

    public GrpcClientOptions() {
        this.scheduleDeadlineAutomatically = false;
        this.timeout = 0;
        this.timeoutUnit = DEFAULT_TIMEOUT_UNIT;
        this.maxMessageSize = 262144L;
    }

    public GrpcClientOptions(GrpcClientOptions other) {
        this.scheduleDeadlineAutomatically = other.scheduleDeadlineAutomatically;
        this.timeout = other.timeout;
        this.timeoutUnit = other.timeoutUnit;
        this.maxMessageSize = other.maxMessageSize;
    }

    public boolean getScheduleDeadlineAutomatically() {
        return this.scheduleDeadlineAutomatically;
    }

    public GrpcClientOptions setScheduleDeadlineAutomatically(boolean handleDeadlineAutomatically) {
        this.scheduleDeadlineAutomatically = handleDeadlineAutomatically;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public GrpcClientOptions setTimeout(int timeout) {
        if ((long)timeout < 0L) {
            throw new IllegalArgumentException("Timeout value must be >= 0");
        }
        this.timeout = timeout;
        return this;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public GrpcClientOptions setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = Objects.requireNonNull(timeoutUnit);
        return this;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public GrpcClientOptions setMaxMessageSize(long maxMessageSize) {
        if (maxMessageSize <= 0L) {
            throw new IllegalArgumentException("Max message size must be > 0");
        }
        if (maxMessageSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max message size must be <= 0xFFFFFFFF");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }
}

