/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2ConnectionUriParser;
import io.vertx.db2client.impl.DB2PoolImpl;
import io.vertx.db2client.impl.Db2PoolOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SingletonSupplier;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class DB2Driver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.db2client";
    public static final DB2Driver INSTANCE = new DB2Driver();

    public Pool newPool(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new DB2PoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        boolean pipelinedPool = options instanceof Db2PoolOptions && ((Db2PoolOptions)options).isPipelined();
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, pipelinedPool, options, null, null, closeFuture);
        ConnectionFactory factory = this.createConnectionFactory((Vertx)vertx, databases);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public DB2ConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = DB2ConnectionUriParser.parse(uri, false);
        return conf == null ? null : new DB2ConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof DB2ConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new DB2ConnectionFactory((VertxInternal)vertx, SingletonSupplier.wrap((Object)database));
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> database) {
        return new DB2ConnectionFactory((VertxInternal)vertx, database);
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new DB2ConnectionImpl(context, factory, conn);
    }
}

