/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.Http1xPool;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.spi.metrics.HttpClientMetrics;

class ClientHandler
extends VertxHttpHandler<ClientConnection> {
    private boolean closeFrameSent;
    private ContextImpl context;
    private ChannelHandlerContext chctx;
    private Http1xPool pool;
    private HttpClientImpl client;
    private Object endpointMetric;
    private HttpClientMetrics metrics;

    public ClientHandler(ContextImpl context, Http1xPool pool, HttpClientImpl client, Object endpointMetric, HttpClientMetrics metrics) {
        this.context = context;
        this.pool = pool;
        this.client = client;
        this.endpointMetric = endpointMetric;
        this.metrics = metrics;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        ClientConnection conn = new ClientConnection(this.pool.version(), this.client, this.endpointMetric, ctx, this.pool.ssl(), this.pool.host(), this.pool.port(), this.context, this.pool, this.metrics);
        this.setConnection(conn);
        if (this.metrics != null) {
            this.context.executeFromIO(() -> {
                Object metric = this.metrics.connected(conn.remoteAddress(), conn.remoteName());
                conn.metric(metric);
                this.metrics.endpointConnected(this.endpointMetric, metric);
            });
        }
    }

    public ChannelHandlerContext context() {
        return this.chctx;
    }

    @Override
    protected void handleMessage(ClientConnection conn, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (msg instanceof HttpObject) {
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                conn.handleException(result.cause());
                conn.close();
                return;
            }
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)obj;
                conn.handleResponse(response);
                return;
            }
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)obj;
                if (chunk.content().isReadable()) {
                    Buffer buff = Buffer.buffer(chunk.content().slice());
                    conn.handleResponseChunk(buff);
                }
                if (chunk instanceof LastHttpContent) {
                    conn.handleResponseEnd((LastHttpContent)chunk);
                }
                return;
            }
        } else if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            switch (frame.type()) {
                case BINARY: 
                case CONTINUATION: 
                case TEXT: {
                    conn.handleWsFrame(frame);
                    break;
                }
                case PING: {
                    chctx.writeAndFlush((Object)new WebSocketFrameImpl(FrameType.PONG, frame.getBinaryData()));
                    break;
                }
                case PONG: {
                    break;
                }
                case CLOSE: {
                    if (this.closeFrameSent) break;
                    chctx.writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.closeFrameSent = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type: " + (Object)((Object)frame.type()));
                }
            }
            return;
        }
        throw new IllegalStateException("Invalid object " + msg);
    }
}

