/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.config.vault.client.Secret;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.Base64;
import java.util.Map;

public class SecretConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, Secret obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "data": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setData(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "lease_duration": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLeaseDuration(((Number)member.getValue()).longValue());
                    break;
                }
                case "lease_id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLeaseId((String)member.getValue());
                    break;
                }
                case "renewable": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRenewable((Boolean)member.getValue());
                    break;
                }
                case "request_id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRequestId((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(Secret obj, JsonObject json) {
        SecretConverter.toJson(obj, json.getMap());
    }

    public static void toJson(Secret obj, Map<String, Object> json) {
        if (obj.getData() != null) {
            json.put("data", obj.getData());
        }
        json.put("lease_duration", obj.getLeaseDuration());
        if (obj.getLeaseId() != null) {
            json.put("lease_id", obj.getLeaseId());
        }
        json.put("renewable", obj.isRenewable());
        if (obj.getRequestId() != null) {
            json.put("request_id", obj.getRequestId());
        }
    }
}

