/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.vault.client.Auth;
import io.vertx.config.vault.client.Secret;
import io.vertx.config.vault.client.SlimVaultClient;
import io.vertx.config.vault.client.TokenRequest;
import io.vertx.config.vault.client.VaultException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

public class VaultConfigStore
implements ConfigStore {
    private final SlimVaultClient client;
    private final JsonObject config;
    private final String path;
    private final VertxInternal vertx;
    private boolean renewable;
    private long validity;

    public VaultConfigStore(Vertx vertx, JsonObject config) {
        this.client = new SlimVaultClient(vertx, config);
        this.config = config;
        this.vertx = (VertxInternal)vertx;
        this.path = Objects.requireNonNull(config.getString("path"), "The path of the secret must be set");
    }

    public Future<Void> close() {
        this.client.close();
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    public Future<Buffer> get() {
        return this.authenticate(false).compose(v -> this.renew()).compose(v -> this.retrieve()).compose(this::extract);
    }

    private Future<Buffer> extract(JsonObject json) {
        Promise promise = Promise.promise();
        if (json == null) {
            promise.complete((Object)new JsonObject().toBuffer());
        } else if (this.config.getString("key") != null) {
            Object value = json.getValue(this.config.getString("key"));
            if (value == null) {
                promise.complete((Object)new JsonObject().toBuffer());
            } else if (value instanceof String) {
                promise.complete((Object)Buffer.buffer((String)((String)value)));
            } else if (value instanceof JsonObject) {
                promise.complete((Object)((JsonObject)value).toBuffer());
            }
        } else {
            promise.complete((Object)json.toBuffer());
        }
        return promise.future();
    }

    private Future<JsonObject> retrieve() {
        PromiseInternal promise = this.vertx.promise();
        this.client.read(this.path, (Handler<AsyncResult<Secret>>)promise);
        return promise.future().map(result -> {
            JsonObject copy = result.getData().copy();
            copy.put("vault-lease-id", (Object)result.getLeaseId());
            copy.put("vault-lease-duration", (Object)result.getLeaseDuration());
            copy.put("vault-renewable", (Object)result.isRenewable());
            return copy;
        }).recover(throwable -> {
            VaultException vaultException;
            if (throwable instanceof VaultException && (vaultException = (VaultException)throwable).getStatusCode() == 404) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((Throwable)throwable);
        });
    }

    private Future<Void> renew() {
        PromiseInternal promise = this.vertx.promise();
        if (this.validity == 0L) {
            promise.complete();
        } else {
            if (this.shouldBeRenewed() && this.renewable) {
                return this.renewToken();
            }
            if (this.shouldBeRenewed()) {
                return this.authenticate(true);
            }
            promise.complete();
        }
        return promise.future();
    }

    private Future<Void> renewToken() {
        PromiseInternal promise = this.vertx.promise();
        this.client.renewSelf(this.config.getLong("lease-duration", Long.valueOf(3600L)), (Handler<AsyncResult<Auth>>)((Handler)arg_0 -> this.lambda$renewToken$4((Promise)promise, arg_0)));
        return promise.future();
    }

    private Future<Void> authenticate(boolean renew) {
        PromiseInternal promise = this.vertx.promise();
        if (!renew && this.client.getToken() != null) {
            promise.complete();
            return promise.future();
        }
        String policy = this.config.getString("auth-backend");
        Objects.requireNonNull(policy, "If you don't provide a token, the auth-backend must be set");
        switch (policy.toLowerCase()) {
            case "token": {
                return this.loginWithToken();
            }
            case "approle": {
                return this.loginWithAppRole();
            }
            case "cert": {
                return this.loginWithCert();
            }
            case "userpass": {
                return this.loginWithUserName();
            }
        }
        throw new IllegalArgumentException("Non supported auth-backend: " + policy);
    }

    private Future<Void> loginWithUserName() {
        PromiseInternal promise = this.vertx.promise();
        JsonObject req = this.config.getJsonObject("user-credentials");
        Objects.requireNonNull(req, "When using username, the `user-credentials` must be set in the configuration");
        String username = req.getString("username");
        String password = req.getString("password");
        String token = req.getString("token");
        Objects.requireNonNull(username, "When using userpass, the username must be set in the `user-credentials` configuration");
        Objects.requireNonNull(password, "When using userpass, the password must be set in the `user-credentials` configuration");
        this.client.loginWithUserCredentials(username, password, (Handler<AsyncResult<Auth>>)((Handler)arg_0 -> this.lambda$loginWithUserName$5((Promise)promise, arg_0)));
        return promise.future();
    }

    private Future<Void> loginWithCert() {
        PromiseInternal promise = this.vertx.promise();
        this.client.loginWithCert((Handler<AsyncResult<Auth>>)((Handler)arg_0 -> this.lambda$loginWithCert$6((Promise)promise, arg_0)));
        return promise.future();
    }

    private Future<Void> loginWithAppRole() {
        PromiseInternal promise = this.vertx.promise();
        JsonObject req = this.config.getJsonObject("approle");
        Objects.requireNonNull(req, "When using approle, the `app-role` must be set in the configuration");
        String roleId = req.getString("role-id");
        String secretId = req.getString("secret-id");
        Objects.requireNonNull(roleId, "When using approle, the role-id must be set in the `approle` configuration");
        Objects.requireNonNull(secretId, "When using approle, the secret-id must be set in the `approle` configuration");
        this.client.loginWithAppRole(roleId, secretId, (Handler<AsyncResult<Auth>>)((Handler)arg_0 -> this.lambda$loginWithAppRole$7((Promise)promise, arg_0)));
        return promise.future();
    }

    private Future<Void> loginWithToken() {
        PromiseInternal promise = this.vertx.promise();
        JsonObject req = this.config.getJsonObject("token-request");
        Objects.requireNonNull(req, "When using a token creation policy, the `token-request` must be set in the configuration");
        String token = req.getString("token");
        Objects.requireNonNull(req, "When using a token creation policy, the `token-request` must be set in the configuration and contains the `token` entry with the original token");
        this.client.setToken(token).createToken(new TokenRequest(req), (Handler<AsyncResult<Auth>>)((Handler)arg_0 -> this.lambda$loginWithToken$8((Promise)promise, arg_0)));
        return promise.future();
    }

    private void manageAuthenticationResult(Promise<Void> future, AsyncResult<Auth> auth) {
        if (auth.failed()) {
            future.fail(auth.cause());
        } else {
            Auth authentication = (Auth)auth.result();
            if (authentication.getClientToken() == null) {
                future.fail("Authentication failed, the token is null");
            } else {
                this.client.setToken(authentication.getClientToken());
                this.renewable = authentication.isRenewable();
                this.validity = System.currentTimeMillis() + authentication.getLeaseDuration() * 1000L;
                future.complete();
            }
        }
    }

    private boolean shouldBeRenewed() {
        long margin;
        long now = System.currentTimeMillis();
        return now >= this.validity - (margin = this.config.getLong("renew-window", Long.valueOf(60000L)).longValue());
    }

    public SlimVaultClient getVaultClient() {
        return this.client;
    }

    private /* synthetic */ void lambda$loginWithToken$8(Promise promise, AsyncResult auth) {
        this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth);
    }

    private /* synthetic */ void lambda$loginWithAppRole$7(Promise promise, AsyncResult auth) {
        this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth);
    }

    private /* synthetic */ void lambda$loginWithCert$6(Promise promise, AsyncResult auth) {
        this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth);
    }

    private /* synthetic */ void lambda$loginWithUserName$5(Promise promise, AsyncResult auth) {
        this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth);
    }

    private /* synthetic */ void lambda$renewToken$4(Promise promise, AsyncResult auth) {
        this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth);
    }
}

