/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.converter;

import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.cert.X509Certificate;
import org.junit.Assert;

public class TestUtils {
    private static Random random = new Random();

    public static Buffer randomBuffer(int length) {
        return TestUtils.randomBuffer(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length) {
        return TestUtils.randomByteArray(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length, boolean avoid, byte avoidByte) {
        byte[] line = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte rand;
            do {
                rand = TestUtils.randomByte();
            } while (avoid && rand == avoidByte);
            line[i] = rand;
        }
        return line;
    }

    public static Buffer randomBuffer(int length, boolean avoid, byte avoidByte) {
        byte[] line = TestUtils.randomByteArray(length, avoid, avoidByte);
        return Buffer.buffer((byte[])line);
    }

    public static byte randomByte() {
        return (byte)((int)(Math.random() * 255.0) - 128);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomPortInt() {
        return random.nextInt(65536);
    }

    public static int randomHighPortInt() {
        return random.nextInt(64512) + 1024;
    }

    public static int randomPositiveInt() {
        int rand;
        while ((rand = random.nextInt()) <= 0) {
        }
        return rand;
    }

    public static long randomPositiveLong() {
        long rand;
        while ((rand = random.nextLong()) <= 0L) {
        }
        return rand;
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static char randomChar() {
        return (char)random.nextInt(16);
    }

    public static short randomShort() {
        return (short)random.nextInt(32768);
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static String randomUnicodeString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c;
            while ((c = (char)(65535.0 * Math.random())) >= '\ufffe' && c <= '\uffff' || c >= '\ud800' && c <= '\udfff') {
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String randomAlphaString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = (char)(65.0 + 25.0 * Math.random());
            builder.append(c);
        }
        return builder.toString();
    }

    public static <E extends Enum<E>> Set<E> randomEnumSet(Class<E> enumType) {
        EnumSet<Enum> set = EnumSet.noneOf(enumType);
        for (Enum e : EnumSet.allOf(enumType)) {
            if (TestUtils.randomPositiveInt() % 2 != 1) continue;
            set.add(e);
        }
        return set;
    }

    public static <E> E randomElement(E[] array) {
        return array[TestUtils.randomPositiveInt() % array.length];
    }

    public static boolean byteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertIllegalArgumentException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void assertNullPointerException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void assertIllegalStateException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void assertIndexOutOfBoundsException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static byte[] compressGzip(String source) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(source.getBytes());
        gos.close();
        return baos.toByteArray();
    }

    public static String cnOf(X509Certificate cert) throws Exception {
        String dn = cert.getSubjectDN().getName();
        LdapName ldapDN = new LdapName(dn);
        for (Rdn rdn : ldapDN.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("cn")) continue;
            return rdn.getValue().toString();
        }
        return null;
    }

    public static File tmpFile(String prefix, String suffix) throws Exception {
        File tmp = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)tmp.delete());
        return tmp;
    }
}

