/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.DataObjectWithLists;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class DataObjectWithListsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, DataObjectWithLists obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "booleanValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            list.add((Boolean)item);
                        }
                    });
                    obj.setBooleanValues(list);
                    break;
                }
                case "dataObjectValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((Boolean)((Object)new TestDataObject((JsonObject)item)));
                        }
                    });
                    obj.setDataObjectValues(list);
                    break;
                }
                case "doubleValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add((Boolean)((Number)item).doubleValue());
                        }
                    });
                    obj.setDoubleValues(list);
                    break;
                }
                case "enumValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Boolean)((Object)TestEnum.valueOf((String)item)));
                        }
                    });
                    obj.setEnumValues(list);
                    break;
                }
                case "floatValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add((Boolean)((Object)Float.valueOf(((Number)item).floatValue())));
                        }
                    });
                    obj.setFloatValues(list);
                    break;
                }
                case "genEnumValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Boolean)((Object)TestGenEnum.valueOf((String)item)));
                        }
                    });
                    obj.setGenEnumValues(list);
                    break;
                }
                case "instantValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Boolean)((Object)Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)item))));
                        }
                    });
                    obj.setInstantValues(list);
                    break;
                }
                case "integerValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add((Boolean)((Number)item).intValue());
                        }
                    });
                    obj.setIntegerValues(list);
                    break;
                }
                case "jsonArrayValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add((Boolean)((JsonArray)item).copy());
                        }
                    });
                    obj.setJsonArrayValues(list);
                    break;
                }
                case "jsonObjectValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((Boolean)((JsonObject)item).copy());
                        }
                    });
                    obj.setJsonObjectValues(list);
                    break;
                }
                case "longValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add((Boolean)((Number)item).longValue());
                        }
                    });
                    obj.setLongValues(list);
                    break;
                }
                case "shortValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add((Boolean)((Number)item).shortValue());
                        }
                    });
                    obj.setShortValues(list);
                    break;
                }
                case "stringValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Boolean> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Boolean)((Object)((String)item)));
                        }
                    });
                    obj.setStringValues(list);
                }
            }
        }
    }

    public static void toJson(DataObjectWithLists obj, JsonObject json) {
        DataObjectWithListsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(DataObjectWithLists obj, Map<String, Object> json) {
    }
}

