/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import connection_request.ConnectionRequestOuterClass;
import glide.api.models.GlideString;
import glide.api.models.configuration.AdvancedBaseClientConfiguration;
import glide.api.models.configuration.BaseClientConfiguration;
import glide.api.models.configuration.ClusterSubscriptionConfiguration;
import glide.api.models.configuration.GlideClientConfiguration;
import glide.api.models.configuration.GlideClusterClientConfiguration;
import glide.api.models.configuration.NodeAddress;
import glide.api.models.configuration.ProtocolVersion;
import glide.api.models.configuration.ReadFrom;
import glide.api.models.configuration.StandaloneSubscriptionConfiguration;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.ConfigurationError;
import glide.com.google.protobuf.ByteString;
import glide.connectors.handlers.ChannelHandler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import lombok.Generated;
import response.ResponseOuterClass;

public class ConnectionManager {
    private final ChannelHandler channel;

    public CompletableFuture<Void> connectToValkey(BaseClientConfiguration configuration) {
        ConnectionRequestOuterClass.ConnectionRequest request = this.createConnectionRequest(configuration);
        return ((CompletableFuture)this.channel.connect(request).exceptionally(this::exceptionHandler)).thenApplyAsync(this::checkGlideRsResponse);
    }

    private ResponseOuterClass.Response exceptionHandler(Throwable e) {
        this.channel.close();
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    private ConnectionRequestOuterClass.ConnectionRequest createConnectionRequest(BaseClientConfiguration configuration) {
        if (configuration instanceof GlideClusterClientConfiguration) {
            return this.setupConnectionRequestBuilderGlideClusterClient((GlideClusterClientConfiguration)configuration).build();
        }
        return this.setupConnectionRequestBuilderGlideClient((GlideClientConfiguration)configuration).build();
    }

    private ConnectionRequestOuterClass.ConnectionRequest.Builder setupConnectionRequestBuilderBaseConfiguration(BaseClientConfiguration configuration) {
        ConnectionRequestOuterClass.ConnectionRequest.Builder connectionRequestBuilder = ConnectionRequestOuterClass.ConnectionRequest.newBuilder();
        for (NodeAddress nodeAddress : configuration.getAddresses()) {
            connectionRequestBuilder.addAddresses(ConnectionRequestOuterClass.NodeAddress.newBuilder().setHost(nodeAddress.getHost()).setPort(nodeAddress.getPort()).build());
        }
        connectionRequestBuilder.setTlsMode(configuration.isUseTLS() ? ConnectionRequestOuterClass.TlsMode.SecureTls : ConnectionRequestOuterClass.TlsMode.NoTls).setReadFrom(this.mapReadFromEnum(configuration.getReadFrom()));
        if (configuration.getCredentials() != null) {
            ConnectionRequestOuterClass.AuthenticationInfo.Builder authenticationInfoBuilder = ConnectionRequestOuterClass.AuthenticationInfo.newBuilder();
            if (configuration.getCredentials().getUsername() != null) {
                authenticationInfoBuilder.setUsername(configuration.getCredentials().getUsername());
            }
            authenticationInfoBuilder.setPassword(configuration.getCredentials().getPassword());
            connectionRequestBuilder.setAuthenticationInfo(authenticationInfoBuilder.build());
        }
        if (configuration.getRequestTimeout() != null) {
            connectionRequestBuilder.setRequestTimeout(configuration.getRequestTimeout());
        }
        if (configuration.getClientName() != null) {
            connectionRequestBuilder.setClientName(configuration.getClientName());
        }
        if (configuration.getInflightRequestsLimit() != null) {
            connectionRequestBuilder.setInflightRequestsLimit(configuration.getInflightRequestsLimit());
        }
        if (configuration.getReadFrom() == ReadFrom.AZ_AFFINITY) {
            if (configuration.getClientAZ() == null) {
                throw new ConfigurationError("`clientAZ` must be set when read_from is set to `AZ_AFFINITY`");
            }
            connectionRequestBuilder.setClientAz(configuration.getClientAZ());
        }
        if (configuration.getReadFrom() == ReadFrom.AZ_AFFINITY_REPLICAS_AND_PRIMARY) {
            if (configuration.getClientAZ() == null) {
                throw new ConfigurationError("`clientAZ` must be set when read_from is set to `AZ_AFFINITY_REPLICAS_AND_PRIMARY`");
            }
            connectionRequestBuilder.setClientAz(configuration.getClientAZ());
        }
        if (configuration.getProtocol() != null) {
            connectionRequestBuilder.setProtocolValue(configuration.getProtocol().ordinal());
        }
        if (configuration.getReconnectStrategy() != null) {
            ConnectionRequestOuterClass.ConnectionRetryStrategy.Builder reconnectionStrategyBuilder = ConnectionRequestOuterClass.ConnectionRetryStrategy.newBuilder().setNumberOfRetries(configuration.getReconnectStrategy().getNumOfRetries()).setExponentBase(configuration.getReconnectStrategy().getExponentBase()).setFactor(configuration.getReconnectStrategy().getFactor());
            if (configuration.getReconnectStrategy().getJitterPercent() != null) {
                reconnectionStrategyBuilder.setJitterPercent(configuration.getReconnectStrategy().getJitterPercent());
            }
            connectionRequestBuilder.setConnectionRetryStrategy(reconnectionStrategyBuilder.build());
        }
        if (configuration.isLazyConnect()) {
            connectionRequestBuilder.setLazyConnect(configuration.isLazyConnect());
        }
        if (configuration.getDatabaseId() != null) {
            connectionRequestBuilder.setDatabaseId(configuration.getDatabaseId());
        }
        return connectionRequestBuilder;
    }

    private ConnectionRequestOuterClass.ConnectionRequest.Builder setupConnectionRequestBuilderGlideClient(GlideClientConfiguration configuration) {
        ConnectionRequestOuterClass.ConnectionRequest.Builder connectionRequestBuilder = this.setupConnectionRequestBuilderBaseConfiguration(configuration);
        connectionRequestBuilder.setClusterModeEnabled(false);
        if (configuration.getSubscriptionConfiguration() != null) {
            if (configuration.getProtocol() == ProtocolVersion.RESP2) {
                throw new ConfigurationError("PubSub subscriptions require RESP3 protocol, but RESP2 was configured.");
            }
            ConnectionRequestOuterClass.PubSubSubscriptions.Builder subscriptionsBuilder = ConnectionRequestOuterClass.PubSubSubscriptions.newBuilder();
            for (Map.Entry<StandaloneSubscriptionConfiguration.PubSubChannelMode, Set<GlideString>> entry : configuration.getSubscriptionConfiguration().getSubscriptions().entrySet()) {
                ConnectionRequestOuterClass.PubSubChannelsOrPatterns.Builder channelsBuilder = ConnectionRequestOuterClass.PubSubChannelsOrPatterns.newBuilder();
                for (GlideString channel : entry.getValue()) {
                    channelsBuilder.addChannelsOrPatterns(ByteString.copyFrom(channel.getBytes()));
                }
                subscriptionsBuilder.putChannelsOrPatternsByType(entry.getKey().ordinal(), channelsBuilder.build());
            }
            connectionRequestBuilder.setPubsubSubscriptions(subscriptionsBuilder.build());
        }
        connectionRequestBuilder = this.setupConnectionRequestBuilderAdvancedBaseConfiguration(connectionRequestBuilder, configuration.getAdvancedConfiguration());
        return connectionRequestBuilder;
    }

    private ConnectionRequestOuterClass.ConnectionRequest.Builder setupConnectionRequestBuilderAdvancedBaseConfiguration(ConnectionRequestOuterClass.ConnectionRequest.Builder connectionRequestBuilder, AdvancedBaseClientConfiguration advancedConfiguration) {
        if (advancedConfiguration.getConnectionTimeout() != null) {
            connectionRequestBuilder.setConnectionTimeout(advancedConfiguration.getConnectionTimeout());
        }
        if (advancedConfiguration.getTlsAdvancedConfiguration().isUseInsecureTLS()) {
            if (connectionRequestBuilder.getTlsMode() == ConnectionRequestOuterClass.TlsMode.NoTls) {
                throw new ConfigurationError("`useInsecureTlS` cannot be enabled when  `useTLS` is disabled.");
            }
            connectionRequestBuilder.setTlsMode(ConnectionRequestOuterClass.TlsMode.InsecureTls);
        }
        return connectionRequestBuilder;
    }

    private ConnectionRequestOuterClass.ConnectionRequest.Builder setupConnectionRequestBuilderGlideClusterClient(GlideClusterClientConfiguration configuration) {
        ConnectionRequestOuterClass.ConnectionRequest.Builder connectionRequestBuilder = this.setupConnectionRequestBuilderBaseConfiguration(configuration);
        connectionRequestBuilder.setClusterModeEnabled(true);
        if (configuration.getSubscriptionConfiguration() != null) {
            if (configuration.getProtocol() == ProtocolVersion.RESP2) {
                throw new ConfigurationError("PubSub subscriptions require RESP3 protocol, but RESP2 was configured.");
            }
            ConnectionRequestOuterClass.PubSubSubscriptions.Builder subscriptionsBuilder = ConnectionRequestOuterClass.PubSubSubscriptions.newBuilder();
            for (Map.Entry<ClusterSubscriptionConfiguration.PubSubClusterChannelMode, Set<GlideString>> entry : configuration.getSubscriptionConfiguration().getSubscriptions().entrySet()) {
                ConnectionRequestOuterClass.PubSubChannelsOrPatterns.Builder channelsBuilder = ConnectionRequestOuterClass.PubSubChannelsOrPatterns.newBuilder();
                for (GlideString channel : entry.getValue()) {
                    channelsBuilder.addChannelsOrPatterns(ByteString.copyFrom(channel.getBytes()));
                }
                subscriptionsBuilder.putChannelsOrPatternsByType(entry.getKey().ordinal(), channelsBuilder.build());
            }
            connectionRequestBuilder.setPubsubSubscriptions(subscriptionsBuilder.build());
        }
        connectionRequestBuilder = this.setupConnectionRequestBuilderAdvancedBaseConfiguration(connectionRequestBuilder, configuration.getAdvancedConfiguration());
        return connectionRequestBuilder;
    }

    private ConnectionRequestOuterClass.ReadFrom mapReadFromEnum(ReadFrom readFrom) {
        switch (readFrom) {
            case PREFER_REPLICA: {
                return ConnectionRequestOuterClass.ReadFrom.PreferReplica;
            }
            case AZ_AFFINITY: {
                return ConnectionRequestOuterClass.ReadFrom.AZAffinity;
            }
            case AZ_AFFINITY_REPLICAS_AND_PRIMARY: {
                return ConnectionRequestOuterClass.ReadFrom.AZAffinityReplicasAndPrimary;
            }
        }
        return ConnectionRequestOuterClass.ReadFrom.Primary;
    }

    private Void checkGlideRsResponse(ResponseOuterClass.Response response) {
        if (response.hasRequestError()) {
            this.throwClosingError("Unhandled request error in response: " + response.getRequestError().getMessage());
        }
        if (response.hasClosingError()) {
            this.throwClosingError("Unhandled closing error in response: " + response.getClosingError());
        }
        if (response.hasRespPointer()) {
            this.throwClosingError("Unexpected data in response");
        }
        if (!response.hasConstantResponse()) {
            this.throwClosingError("Unexpected empty data in response");
        }
        return null;
    }

    private void throwClosingError(String msg) {
        this.closeConnection();
        throw new ClosingException(msg);
    }

    public Future<Void> closeConnection() {
        return this.channel.close();
    }

    @Generated
    public ConnectionManager(ChannelHandler channel) {
        this.channel = channel;
    }
}

