/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.handlers;

import glide.api.logging.Logger;
import glide.connectors.handlers.CallbackDispatcher;
import glide.connectors.handlers.MessageHandler;
import glide.io.netty.channel.ChannelHandlerContext;
import glide.io.netty.channel.ChannelInboundHandlerAdapter;
import lombok.Generated;
import lombok.NonNull;
import response.ResponseOuterClass;

public class ReadHandler
extends ChannelInboundHandlerAdapter {
    private final CallbackDispatcher callbackDispatcher;

    @Override
    public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws MessageHandler.MessageCallbackException {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg instanceof ResponseOuterClass.Response) {
            ResponseOuterClass.Response response = (ResponseOuterClass.Response)msg;
            this.callbackDispatcher.completeRequest(response);
            ctx.fireChannelRead(msg);
            return;
        }
        throw new RuntimeException("Unexpected message in socket");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof MessageHandler.MessageCallbackException) {
            Logger.log(Logger.Level.ERROR, "read handler", () -> "=== Exception thrown from pubsub callback " + String.valueOf(ctx), cause.getCause());
            cause.printStackTrace();
            throw ((MessageHandler.MessageCallbackException)cause).getCause();
        }
        Logger.log(Logger.Level.ERROR, "read handler", () -> "=== exceptionCaught " + String.valueOf(ctx), cause);
        this.callbackDispatcher.distributeClosingException("An unhandled error while reading from UDS channel: " + String.valueOf(cause));
    }

    @Generated
    public ReadHandler(CallbackDispatcher callbackDispatcher) {
        this.callbackDispatcher = callbackDispatcher;
    }
}

