/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.handlers;

import command_request.CommandRequestOuterClass;
import connection_request.ConnectionRequestOuterClass;
import glide.connectors.handlers.CallbackDispatcher;
import glide.connectors.handlers.ProtobufSocketChannelInitializer;
import glide.connectors.resources.ThreadPoolResource;
import glide.io.netty.bootstrap.Bootstrap;
import glide.io.netty.channel.Channel;
import glide.io.netty.channel.ChannelFuture;
import glide.io.netty.channel.ChannelFutureListener;
import glide.io.netty.channel.unix.DomainSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import response.ResponseOuterClass;

public class ChannelHandler {
    protected final Channel channel;
    protected final CallbackDispatcher callbackDispatcher;
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    public boolean isClosed() {
        return this.isClosed.get() || !this.channel.isOpen();
    }

    public ChannelHandler(CallbackDispatcher callbackDispatcher, String socketPath, ThreadPoolResource threadPoolResource) throws InterruptedException {
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(threadPoolResource.getEventLoopGroup())).channel(threadPoolResource.getDomainSocketChannelClass())).handler(new ProtobufSocketChannelInitializer(callbackDispatcher))).connect(new DomainSocketAddress(socketPath)).sync().channel();
        this.callbackDispatcher = callbackDispatcher;
    }

    public CompletableFuture<ResponseOuterClass.Response> write(CommandRequestOuterClass.CommandRequest.Builder request, boolean flush) {
        Pair<Integer, CompletableFuture<ResponseOuterClass.Response>> commandId = this.callbackDispatcher.registerRequest();
        request.setCallbackIdx((Integer)commandId.getKey());
        if (flush) {
            this.channel.writeAndFlush(request.build()).addListener(new NettyFutureErrorHandler((CompletableFuture)commandId.getValue()));
        } else {
            this.channel.write(request.build()).addListener(new NettyFutureErrorHandler((CompletableFuture)commandId.getValue()));
        }
        return (CompletableFuture)commandId.getValue();
    }

    public CompletableFuture<ResponseOuterClass.Response> connect(ConnectionRequestOuterClass.ConnectionRequest request) {
        CompletableFuture<ResponseOuterClass.Response> future = this.callbackDispatcher.registerConnection();
        this.channel.writeAndFlush(request).addListener(new NettyFutureErrorHandler(future));
        return future;
    }

    public ChannelFuture close() {
        this.isClosed.set(true);
        this.callbackDispatcher.shutdownGracefully();
        return this.channel.close();
    }

    private static class NettyFutureErrorHandler
    implements ChannelFutureListener {
        private final CompletableFuture<ResponseOuterClass.Response> promise;

        @Override
        public void operationComplete(@NonNull ChannelFuture channelFuture) throws Exception {
            Throwable cause;
            if (channelFuture == null) {
                throw new NullPointerException("channelFuture is marked non-null but is null");
            }
            if (channelFuture.isCancelled()) {
                this.promise.cancel(false);
            }
            if ((cause = channelFuture.cause()) != null) {
                this.promise.completeExceptionally(cause);
            }
        }

        @Generated
        public NettyFutureErrorHandler(CompletableFuture<ResponseOuterClass.Response> promise) {
            this.promise = promise;
        }
    }
}

