/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.geospatial;

import glide.api.models.commands.SortOrder;
import java.util.ArrayList;

public class GeoSearchResultOptions {
    public static final String COUNT_VALKEY_API = "COUNT";
    public static final String ANY_VALKEY_API = "ANY";
    private final SortOrder sortOrder;
    private final long count;
    private final boolean isAny;

    public GeoSearchResultOptions(long count) {
        this.sortOrder = null;
        this.count = count;
        this.isAny = false;
    }

    public GeoSearchResultOptions(long count, boolean isAny) {
        this.sortOrder = null;
        this.count = count;
        this.isAny = isAny;
    }

    public GeoSearchResultOptions(SortOrder order) {
        this.sortOrder = order;
        this.count = -1L;
        this.isAny = false;
    }

    public GeoSearchResultOptions(SortOrder order, long count) {
        this.sortOrder = order;
        this.count = count;
        this.isAny = false;
    }

    public GeoSearchResultOptions(SortOrder order, long count, boolean isAny) {
        this.sortOrder = order;
        this.count = count;
        this.isAny = isAny;
    }

    public String[] toArgs() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.count > 0L) {
            arguments.add(COUNT_VALKEY_API);
            arguments.add(Long.toString(this.count));
            if (this.isAny) {
                arguments.add(ANY_VALKEY_API);
            }
        }
        if (this.sortOrder != null) {
            arguments.add(this.sortOrder.toString());
        }
        return arguments.toArray(new String[0]);
    }
}

