/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.bitmap;

import glide.api.models.GlideString;
import glide.utils.ArrayTransformUtils;
import java.util.Arrays;
import lombok.Generated;

public class BitFieldOptions {
    public static final String GET_COMMAND_STRING = "GET";
    public static final String SET_COMMAND_STRING = "SET";
    public static final String INCRBY_COMMAND_STRING = "INCRBY";
    public static final String OVERFLOW_COMMAND_STRING = "OVERFLOW";
    public static final String UNSIGNED_ENCODING_PREFIX = "u";
    public static final String SIGNED_ENCODING_PREFIX = "i";
    public static final String OFFSET_MULTIPLIER_PREFIX = "#";

    public static String[] createBitFieldArgs(BitFieldSubCommands[] subCommands) {
        String[] arguments = new String[]{};
        for (int i = 0; i < subCommands.length; ++i) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, subCommands[i].toArgs());
        }
        return arguments;
    }

    public static GlideString[] createBitFieldGlideStringArgs(BitFieldSubCommands[] subCommands) {
        return (GlideString[])Arrays.stream(BitFieldOptions.createBitFieldArgs(subCommands)).map(GlideString::gs).toArray(GlideString[]::new);
    }

    public static final class OffsetMultiplier
    implements BitOffset {
        private final String offset;

        public OffsetMultiplier(long offset) {
            this.offset = BitFieldOptions.OFFSET_MULTIPLIER_PREFIX.concat(Long.toString(offset));
        }

        @Override
        @Generated
        public String getOffset() {
            return this.offset;
        }
    }

    public static final class Offset
    implements BitOffset {
        private final String offset;

        public Offset(long offset) {
            this.offset = Long.toString(offset);
        }

        @Override
        @Generated
        public String getOffset() {
            return this.offset;
        }
    }

    private static interface BitOffset {
        public String getOffset();
    }

    public static final class UnsignedEncoding
    implements BitEncoding {
        private final String encoding;

        public UnsignedEncoding(long encodingLength) {
            this.encoding = BitFieldOptions.UNSIGNED_ENCODING_PREFIX.concat(Long.toString(encodingLength));
        }

        @Override
        @Generated
        public String getEncoding() {
            return this.encoding;
        }
    }

    public static final class SignedEncoding
    implements BitEncoding {
        private final String encoding;

        public SignedEncoding(long encodingLength) {
            this.encoding = BitFieldOptions.SIGNED_ENCODING_PREFIX.concat(Long.toString(encodingLength));
        }

        @Override
        @Generated
        public String getEncoding() {
            return this.encoding;
        }
    }

    private static interface BitEncoding {
        public String getEncoding();
    }

    public static final class BitFieldOverflow
    implements BitFieldSubCommands {
        private final BitOverflowControl overflowControl;

        @Override
        public String[] toArgs() {
            return new String[]{BitFieldOptions.OVERFLOW_COMMAND_STRING, this.overflowControl.toString()};
        }

        @Generated
        public BitFieldOverflow(BitOverflowControl overflowControl) {
            this.overflowControl = overflowControl;
        }

        public static enum BitOverflowControl {
            WRAP,
            SAT,
            FAIL;

        }
    }

    public static final class BitFieldIncrby
    implements BitFieldSubCommands {
        private final BitEncoding encoding;
        private final BitOffset offset;
        private final long increment;

        @Override
        public String[] toArgs() {
            return new String[]{BitFieldOptions.INCRBY_COMMAND_STRING, this.encoding.getEncoding(), this.offset.getOffset(), Long.toString(this.increment)};
        }

        @Generated
        public BitFieldIncrby(BitEncoding encoding, BitOffset offset, long increment) {
            this.encoding = encoding;
            this.offset = offset;
            this.increment = increment;
        }
    }

    public static final class BitFieldSet
    implements BitFieldSubCommands {
        private final BitEncoding encoding;
        private final BitOffset offset;
        private final long value;

        @Override
        public String[] toArgs() {
            return new String[]{BitFieldOptions.SET_COMMAND_STRING, this.encoding.getEncoding(), this.offset.getOffset(), Long.toString(this.value)};
        }

        @Generated
        public BitFieldSet(BitEncoding encoding, BitOffset offset, long value) {
            this.encoding = encoding;
            this.offset = offset;
            this.value = value;
        }
    }

    public static final class BitFieldGet
    implements BitFieldReadOnlySubCommands {
        private final BitEncoding encoding;
        private final BitOffset offset;

        @Override
        public String[] toArgs() {
            return new String[]{BitFieldOptions.GET_COMMAND_STRING, this.encoding.getEncoding(), this.offset.getOffset()};
        }

        @Generated
        public BitFieldGet(BitEncoding encoding, BitOffset offset) {
            this.encoding = encoding;
            this.offset = offset;
        }
    }

    public static interface BitFieldReadOnlySubCommands
    extends BitFieldSubCommands {
    }

    public static interface BitFieldSubCommands {
        public String[] toArgs();
    }
}

