/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class SortBaseOptions {
    public static final String LIMIT_COMMAND_STRING = "LIMIT";
    public static final String ALPHA_COMMAND_STRING = "ALPHA";
    public static final String STORE_COMMAND_STRING = "STORE";
    private final Limit limit;
    private final OrderBy orderBy;
    private final boolean isAlpha;

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.limit != null) {
            optionArgs.addAll(List.of(LIMIT_COMMAND_STRING, Long.toString(this.limit.offset), Long.toString(this.limit.count)));
        }
        if (this.orderBy != null) {
            optionArgs.add(this.orderBy.toString());
        }
        if (this.isAlpha) {
            optionArgs.add(ALPHA_COMMAND_STRING);
        }
        return optionArgs.toArray(new String[0]);
    }

    @Generated
    protected SortBaseOptions(SortBaseOptionsBuilder<?, ?> b) {
        this.limit = b.limit;
        this.orderBy = b.orderBy;
        this.isAlpha = b.isAlpha;
    }

    public static enum OrderBy {
        ASC,
        DESC;


        @Generated
        private OrderBy() {
        }
    }

    public static final class Limit {
        private final long offset;
        private final long count;

        @Generated
        public Limit(long offset, long count) {
            this.offset = offset;
            this.count = count;
        }
    }

    public static abstract class SortBaseOptionsBuilder<C extends SortBaseOptions, B extends SortBaseOptionsBuilder<C, B>> {
        @Generated
        private Limit limit;
        @Generated
        private OrderBy orderBy;
        @Generated
        private boolean isAlpha;

        public B alpha() {
            this.isAlpha = true;
            return this.self();
        }

        @Generated
        public B limit(Limit limit) {
            this.limit = limit;
            return this.self();
        }

        @Generated
        public B orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this.self();
        }

        @Generated
        public B isAlpha(boolean isAlpha) {
            this.isAlpha = isAlpha;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SortBaseOptions.SortBaseOptionsBuilder(limit=" + String.valueOf(this.limit) + ", orderBy=" + String.valueOf((Object)this.orderBy) + ", isAlpha=" + this.isAlpha + ")";
        }
    }
}

