/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import io.trino.tpch.Distribution;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public final class DistributionLoader {
    private DistributionLoader() {
    }

    public static <R extends Readable & Closeable> Map<String, Distribution> loadDistribution(CharSource input) throws IOException {
        try (Stream lines = input.lines();){
            Map<String, Distribution> map = DistributionLoader.loadDistributions(lines.map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).iterator());
            return map;
        }
    }

    private static Distribution loadDistribution(Iterator<String> lines, String name) {
        int count = -1;
        ImmutableMap.Builder members = ImmutableMap.builder();
        while (lines.hasNext()) {
            int weight;
            String line = lines.next();
            if (DistributionLoader.isEnd(name, line)) {
                ImmutableMap weights = members.build();
                Preconditions.checkState((count == weights.size() ? 1 : 0) != 0, (String)"Expected %d entries in distribution %s, but only %d entries were found", (int)count, (int)weights.size());
                return new Distribution(name, (Map<String, Integer>)weights);
            }
            ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'|').trimResults().omitEmptyStrings().split((CharSequence)line));
            Preconditions.checkState((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain two parts, but it contains %d parts: %s", (int)parts.size(), (Object)line);
            String value = (String)parts.get(0);
            try {
                weight = Integer.parseInt((String)parts.get(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("Invalid distribution %s: invalid weight on line %s", name, line));
            }
            if (value.equalsIgnoreCase("count")) {
                count = weight;
                continue;
            }
            members.put((Object)value, (Object)weight);
        }
        throw new IllegalStateException(String.format("Invalid distribution %s: no end statement", name));
    }

    private static boolean isEnd(String name, String line) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings().split((CharSequence)line));
        if (((String)parts.get(0)).equalsIgnoreCase("END")) {
            Preconditions.checkState((parts.size() == 2 && ((String)parts.get(1)).equalsIgnoreCase(name) ? 1 : 0) != 0, (String)"Expected end statement be 'END %s', but was '%s'", (Object)name, (Object)line);
            return true;
        }
        return false;
    }

    private static Map<String, Distribution> loadDistributions(Iterator<String> lines) {
        ImmutableMap.Builder distributions = ImmutableMap.builder();
        while (lines.hasNext()) {
            String line = lines.next();
            ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings().split((CharSequence)line));
            if (parts.size() != 2 || !((String)parts.get(0)).equalsIgnoreCase("BEGIN")) continue;
            String name = (String)parts.get(1);
            Distribution distribution = DistributionLoader.loadDistribution(lines, name);
            distributions.put((Object)name.toLowerCase(), (Object)distribution);
        }
        return distributions.build();
    }
}

