/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public class Region
implements TpchEntity {
    private final long rowNumber;
    private final long regionKey;
    private final String name;
    private final String comment;

    public Region(long rowNumber, long regionKey, String name, String comment) {
        this.rowNumber = rowNumber;
        this.regionKey = regionKey;
        this.name = Objects.requireNonNull(name, "name is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getRegionKey() {
        return this.regionKey;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.regionKey, this.name, this.comment);
    }
}

