/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public class PartSupplier
implements TpchEntity {
    private final long rowNumber;
    private final long partKey;
    private final long supplierKey;
    private final int availableQuantity;
    private final long supplyCost;
    private final String comment;

    public PartSupplier(long rowNumber, long partKey, long supplierKey, int availableQuantity, long supplyCost, String comment) {
        this.rowNumber = rowNumber;
        this.partKey = partKey;
        this.supplierKey = supplierKey;
        this.availableQuantity = availableQuantity;
        this.supplyCost = supplyCost;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getPartKey() {
        return this.partKey;
    }

    public long getSupplierKey() {
        return this.supplierKey;
    }

    public int getAvailableQuantity() {
        return this.availableQuantity;
    }

    public double getSupplyCost() {
        return (double)this.supplyCost / 100.0;
    }

    public long getSupplyCostInCents() {
        return this.supplyCost;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.partKey, this.supplierKey, this.availableQuantity, GenerateUtils.formatMoney(this.supplyCost), this.comment);
    }
}

