/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.MoreObjects;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.type.BigintType;

public class TpchBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final long rowsPerBucket;

    public TpchBucketFunction(int bucketCount, long rowsPerBucket) {
        this.bucketCount = bucketCount;
        this.rowsPerBucket = rowsPerBucket;
    }

    public int getBucket(Page page, int position) {
        Block block = page.getBlock(0);
        if (block.isNull(position)) {
            return 0;
        }
        long orderKey = BigintType.BIGINT.getLong(block, position);
        long rowNumber = TpchBucketFunction.rowNumberFromOrderKey(orderKey);
        int bucket = Math.toIntExact(rowNumber / this.rowsPerBucket);
        if (bucket >= this.bucketCount) {
            bucket = this.bucketCount - 1;
        }
        return bucket;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).add("rowsPerBucket", this.rowsPerBucket).toString();
    }

    private static long rowNumberFromOrderKey(long orderKey) {
        return ((orderKey & 0xFFFFFFFFFFFFFFE0L) >>> 2 | orderKey & 7L) - 1L;
    }
}

