/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds.statistics;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.tpcds.statistics.TableStatisticsData;
import io.trino.tpcds.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class TableStatisticsDataRepository {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());

    public void save(String schemaName, Table table, TableStatisticsData statisticsData) {
        schemaName = this.normalizeSchemaName(schemaName);
        String filename = table.getName();
        Path path = Paths.get("trino-tpcds", "src", "main", "resources", "tpcds", "statistics", schemaName, filename + ".json");
        this.writeStatistics(path, statisticsData);
    }

    private String normalizeSchemaName(String schemaName) {
        return schemaName.trim().replaceAll("\\.0+$", "");
    }

    private void writeStatistics(Path path, TableStatisticsData tableStatisticsData) {
        File file = path.toFile();
        file.getParentFile().mkdirs();
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)tableStatisticsData);
            try (FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8, true);){
                fileWriter.append('\n');
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save table statistics data", e);
        }
    }

    public Optional<TableStatisticsData> load(String schemaName, Table table) {
        schemaName = this.normalizeSchemaName(schemaName);
        String filename = table.getName();
        String resourcePath = "/tpcds/statistics/" + schemaName + "/" + filename + ".json";
        return this.readStatistics(resourcePath);
    }

    private Optional<TableStatisticsData> readStatistics(String resourcePath) {
        URL resource = this.getClass().getResource(resourcePath);
        if (resource == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((TableStatisticsData)JsonUtils.parseJson((ObjectMapper)this.objectMapper, (URL)resource, TableStatisticsData.class));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to parse stats from resource [%s]", resourcePath), e);
        }
    }
}

