/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingIdType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;

public class TestingTypeManager
implements TypeManager {
    private static final List<Type> TYPES = ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)VarbinaryType.VARBINARY, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Object)DateType.DATE, (Object)((Object)TestingIdType.ID), (Object)HyperLogLogType.HYPER_LOG_LOG);
    private final TypeOperators typeOperators = new TypeOperators();

    public Type getType(TypeSignature signature) {
        for (Type type : TYPES) {
            if (!signature.getBase().equals(type.getTypeSignature().getBase())) continue;
            return type;
        }
        throw new TypeNotFoundException(signature);
    }

    public Type fromSqlType(String type) {
        throw new UnsupportedOperationException();
    }

    public Type getType(TypeId id) {
        for (Type type : TYPES) {
            if (!type.getTypeId().equals((Object)id)) continue;
            return type;
        }
        throw new IllegalArgumentException("Type not found: " + id);
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }
}

