/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.Int128;
import java.math.BigInteger;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestInt128 {
    @Test
    public void testFromBigEndian() {
        byte[] bytes = new byte[]{1};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)0L, (long)1L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{-1};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)-1L, (long)-1L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)0L, (long)72623859790382856L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{-128, 2, 3, 4, 5, 6, 7, 8};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)-1L, (long)-9222805771102320888L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)258L, (long)217304205466536202L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{-128, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)-32766L, (long)217304205466536202L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 85};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)72623859790382856L, (long)651345242494996309L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{-128, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 85};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)-9222805771102320888L, (long)651345242494996309L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 85};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)72623859790382856L, (long)651345242494996309L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        bytes = new byte[]{-1, -1, -128, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 85};
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Int128.fromBigEndian((byte[])bytes)).isEqualTo((Object)Int128.valueOf((long)-9222805771102320888L, (long)651345242494996309L))).isEqualTo((Object)Int128.valueOf((BigInteger)new BigInteger(bytes)));
        Assertions.assertThatThrownBy(() -> Int128.fromBigEndian((byte[])new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0})).isInstanceOf(ArithmeticException.class);
        Assertions.assertThatThrownBy(() -> Int128.fromBigEndian((byte[])new byte[]{-2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0})).isInstanceOf(ArithmeticException.class);
    }
}

