/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.jmh.Benchmarks;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=1)
@Warmup(iterations=10)
@Measurement(iterations=20)
public class BenchmarkInt128 {
    @Benchmark
    public Int128 multiplyLongLong(Data data) {
        return Int128Math.multiply((long)data.longLeft, (long)data.longRight);
    }

    @Benchmark
    public Int128 multiplyLongInt(Data data) {
        return Int128Math.multiply((long)data.longLeft, (long)data.intRight);
    }

    @Benchmark
    public Int128 multiply128Int(Data data) {
        return Int128Math.multiply((Int128)data.int128, (long)data.intRight);
    }

    @Benchmark
    public Int128 multiply128(Data data) {
        return Int128Math.multiply((long)data.leftHigh, (long)data.leftLow, (long)data.rightHigh, (long)data.rightLow);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkInt128.class).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public long longLeft;
        public long longRight;
        public int intRight;
        public long leftHigh;
        public long leftLow;
        public long rightHigh;
        public long rightLow;
        public Int128 int128;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.longLeft = ThreadLocalRandom.current().nextLong();
            this.longRight = ThreadLocalRandom.current().nextLong();
            this.intRight = ThreadLocalRandom.current().nextInt();
            this.leftLow = ThreadLocalRandom.current().nextLong();
            this.leftHigh >>= 63;
            this.rightLow = ThreadLocalRandom.current().nextLong();
            this.rightHigh >>= 63;
            this.int128 = Int128.valueOf((long)ThreadLocalRandom.current().nextLong());
        }
    }
}

