/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import com.google.common.base.Verify;
import com.google.common.primitives.Primitives;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.util.OptionalDouble;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatsUtil {
    @Test
    public void testToStatsRepresentation() {
        TestStatsUtil.assertToStatsRepresentation((Type)BigintType.BIGINT, 123456L, 123456.0);
        TestStatsUtil.assertToStatsRepresentation((Type)IntegerType.INTEGER, 12345L, 12345.0);
        TestStatsUtil.assertToStatsRepresentation((Type)SmallintType.SMALLINT, 1234L, 1234.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TinyintType.TINYINT, 123L, 123.0);
        TestStatsUtil.assertToStatsRepresentation((Type)DoubleType.DOUBLE, 0.1, 0.1);
        TestStatsUtil.assertToStatsRepresentation((Type)RealType.REAL, Float.floatToIntBits(0.2f), 0.2f);
        TestStatsUtil.assertToStatsRepresentation((Type)DecimalType.createDecimalType((int)5, (int)2), 12345L, 123.45);
        TestStatsUtil.assertToStatsRepresentation((Type)DecimalType.createDecimalType((int)25, (int)5), Decimals.valueOf((BigDecimal)new BigDecimal("12345678901234567890.12345")), 1.2345678901234567E19);
        TestStatsUtil.assertToStatsRepresentation((Type)DateType.DATE, 1L, 1.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampType.createTimestampType((int)0), 3000000L, 3000000.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampType.createTimestampType((int)3), 3000L, 3000.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampType.createTimestampType((int)6), 3L, 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampType.createTimestampType((int)9), new LongTimestamp(3L, 0), 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampType.createTimestampType((int)12), new LongTimestamp(3L, 999), 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), DateTimeEncoding.packDateTimeWithZone((long)3000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), 3000.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), DateTimeEncoding.packDateTimeWithZone((long)3L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)3L, (int)999999999, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)3L, (int)999999999, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), 3.0);
        TestStatsUtil.assertToStatsRepresentation((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)3L, (int)999999999, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), 3.0);
    }

    private static void assertToStatsRepresentation(Type type, Object trinoValue, double expected) {
        Verify.verify((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(trinoValue), (String)"Incorrect class of value for %s: %s", (Object)type, trinoValue.getClass());
        Assert.assertEquals((Object)StatsUtil.toStatsRepresentation((Type)type, (Object)trinoValue), (Object)OptionalDouble.of(expected));
    }
}

