/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import io.trino.spi.statistics.DoubleRange;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleRange {
    @Test
    public void testRange() {
        TestDoubleRange.assertRange(0.0, 0.0);
        TestDoubleRange.assertRange(0.0, 0.1);
        TestDoubleRange.assertRange(-0.1, 0.1);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, 0.0);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, 0.0);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, -1.7976931348623157E308);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, -1.7976931348623157E308);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, -3.4028234663852886E38);
        TestDoubleRange.assertRange(Double.MAX_VALUE, Double.POSITIVE_INFINITY);
        TestDoubleRange.assertRange(3.4028234663852886E38, Double.POSITIVE_INFINITY);
        TestDoubleRange.assertRange(Double.MAX_VALUE, Double.POSITIVE_INFINITY);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestDoubleRange.assertRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.NaN, 0.0)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(0.0, Double.NaN)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.NaN, Double.NaN)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.NaN, Double.NaN)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(1.0, 0.0)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(0.0, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(0.0, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(-1.7976931348623157E308, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(-3.4028234663852886E38, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(-1.7976931348623157E308, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, Double.MAX_VALUE)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, Double.MAX_VALUE)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, 3.4028234663852886E38)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, 0.0)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new DoubleRange(Double.POSITIVE_INFINITY, 0.0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testUnion() {
        Assert.assertEquals((Object)DoubleRange.union((DoubleRange)new DoubleRange(1.0, 2.0), (DoubleRange)new DoubleRange(4.0, 5.0)), (Object)new DoubleRange(1.0, 5.0));
        Assert.assertEquals((Object)DoubleRange.union((DoubleRange)new DoubleRange(1.0, 2.0), (DoubleRange)new DoubleRange(1.0, 2.0)), (Object)new DoubleRange(1.0, 2.0));
        Assert.assertEquals((Object)DoubleRange.union((DoubleRange)new DoubleRange(4.0, 5.0), (DoubleRange)new DoubleRange(1.0, 2.0)), (Object)new DoubleRange(1.0, 5.0));
        Assert.assertEquals((Object)DoubleRange.union((DoubleRange)new DoubleRange(Double.NEGATIVE_INFINITY, 0.0), (DoubleRange)new DoubleRange(0.0, Double.POSITIVE_INFINITY)), (Object)new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)DoubleRange.union((DoubleRange)new DoubleRange(0.0, Double.POSITIVE_INFINITY), (DoubleRange)new DoubleRange(Double.NEGATIVE_INFINITY, 0.0)), (Object)new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    private static void assertRange(double min, double max) {
        DoubleRange range = new DoubleRange(min, max);
        Assert.assertEquals((Object)range.getMin(), (Object)min);
        Assert.assertEquals((Object)range.getMax(), (Object)max);
    }
}

