/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestValueSet {
    @Test
    public void testRejectNullOnCreate() {
        VarcharType varcharType = VarcharType.createVarcharType((int)25);
        Slice abc = Slices.utf8Slice((String)"abc");
        Slice def = Slices.utf8Slice((String)"def");
        Slice ghi = Slices.utf8Slice((String)"ghi");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)varcharType, null, (Object[])new Object[0])).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)varcharType, (Object)abc, (Object[])new Object[]{def, null, ghi})).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> ValueSet.copyOf((Type)varcharType, Arrays.asList(abc, def, null, ghi))).hasMessage("value is null");
    }

    @Test
    public void testRejectDoubleNaNOnCreate() {
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)DoubleType.DOUBLE, (Object)Double.NaN, (Object[])new Object[0])).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)DoubleType.DOUBLE, (Object)Double.longBitsToDouble(9221140251894092340L), (Object[])new Object[0])).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)DoubleType.DOUBLE, (Object)42.0, (Object[])new Object[]{123.0, Double.NaN, 127.0})).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)DoubleType.DOUBLE, (Object)Double.NaN, (Object[])new Object[]{42.0, 123.0, 127.0})).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.copyOf((Type)DoubleType.DOUBLE, List.of(Double.valueOf(42.0), Double.valueOf(123.0), Double.valueOf(Double.NaN), Double.valueOf(127.0)))).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.copyOf((Type)DoubleType.DOUBLE, List.of(Double.valueOf(Double.NaN), Double.valueOf(42.0), Double.valueOf(123.0), Double.valueOf(127.0)))).hasMessage("cannot use NaN as range bound");
    }

    @Test
    public void testRejectRealNaNOnCreate() {
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)RealType.REAL, (Object)TestValueSet.real(Float.NaN), (Object[])new Object[0])).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)RealType.REAL, (Object)2143294004L, (Object[])new Object[0])).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)RealType.REAL, (Object)TestValueSet.real(42.0f), (Object[])new Object[]{TestValueSet.real(123.0f), TestValueSet.real(Float.NaN), TestValueSet.real(127.0f)})).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.of((Type)RealType.REAL, (Object)TestValueSet.real(Float.NaN), (Object[])new Object[]{TestValueSet.real(42.0f), TestValueSet.real(123.0f), TestValueSet.real(127.0f)})).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.copyOf((Type)RealType.REAL, List.of(Long.valueOf(TestValueSet.real(42.0f)), Long.valueOf(TestValueSet.real(123.0f)), Long.valueOf(TestValueSet.real(Float.NaN)), Long.valueOf(TestValueSet.real(127.0f))))).hasMessage("cannot use NaN as range bound");
        Assertions.assertThatThrownBy(() -> ValueSet.copyOf((Type)RealType.REAL, List.of(Long.valueOf(TestValueSet.real(Float.NaN)), Long.valueOf(TestValueSet.real(42.0f)), Long.valueOf(TestValueSet.real(123.0f)), Long.valueOf(TestValueSet.real(127.0f))))).hasMessage("cannot use NaN as range bound");
    }

    private static long real(float value) {
        return Float.floatToRawIntBits(value);
    }
}

