/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleDomain {
    private static final ColumnHandle A = new TestingColumnHandle("a");
    private static final ColumnHandle B = new TestingColumnHandle("b");
    private static final ColumnHandle C = new TestingColumnHandle("c");
    private static final ColumnHandle D = new TestingColumnHandle("d");
    private static final ColumnHandle E = new TestingColumnHandle("e");

    @Test
    public void testNone() {
        Assert.assertTrue((boolean)TupleDomain.none().isNone());
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertEquals((Object)TupleDomain.none(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
    }

    @Test
    public void testAll() {
        Assert.assertTrue((boolean)TupleDomain.all().isAll());
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertEquals((Object)TupleDomain.all(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of()));
    }

    @Test
    public void testIntersection() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true)).buildOrThrow());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)10.0), (Range[])new Range[0]), (boolean)false)).buildOrThrow());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)10.0, (boolean)false), (Range[])new Range[0]), (boolean)false)).buildOrThrow());
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
        Assert.assertEquals((Object)tupleDomain2.intersect(tupleDomain1), (Object)expectedTupleDomain);
        Assert.assertEquals((Object)TupleDomain.intersect((List)ImmutableList.of()), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.intersect((List)ImmutableList.of((Object)tupleDomain1)), (Object)tupleDomain1);
        Assert.assertEquals((Object)TupleDomain.intersect((List)ImmutableList.of((Object)tupleDomain1, (Object)tupleDomain2)), (Object)expectedTupleDomain);
        TupleDomain tupleDomain3 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)5.0, (boolean)true, (Object)100.0, (boolean)true), (Range[])new Range[0]), (boolean)true)));
        expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)5.0, (boolean)true, (Object)10.0, (boolean)false), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TupleDomain.intersect((List)ImmutableList.of((Object)tupleDomain1, (Object)tupleDomain2, (Object)tupleDomain3)), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneIntersection() {
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.all()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.all().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.none().intersect(TupleDomain.none()), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull((Type)BigintType.BIGINT))).intersect(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull((Type)BigintType.BIGINT)))), (Object)TupleDomain.none());
    }

    @Test
    public void testMismatchedColumnIntersection() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertEquals((Object)tupleDomain1.intersect(tupleDomain2), (Object)expectedTupleDomain);
    }

    @Test
    public void testIntersectResultType() {
        TupleDomain numberDomain = TupleDomain.withColumnDomains(Map.of(10, Domain.singleValue((Type)BigintType.BIGINT, (Object)42L)));
        TupleDomain integerDomain = TupleDomain.withColumnDomains(Map.of(10, Domain.multipleValues((Type)BigintType.BIGINT, List.of(Long.valueOf(41L), Long.valueOf(42L), Long.valueOf(42L)))));
        TupleDomain intersection = numberDomain.intersect(integerDomain);
        Assert.assertEquals((Object)intersection, (Object)numberDomain);
        intersection = TupleDomain.intersect(List.of(integerDomain, numberDomain));
        Assert.assertEquals((Object)intersection, (Object)numberDomain);
    }

    @Test
    public void testColumnWiseUnion() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.onlyNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true)).buildOrThrow());
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)B, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)).put((Object)C, (Object)Domain.notNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)10.0), (Range[])new Range[0]), (boolean)false)).buildOrThrow());
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)VarcharType.VARCHAR)).put((Object)B, (Object)Domain.notNull((Type)DoubleType.DOUBLE)).put((Object)C, (Object)Domain.all((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)E, (Object)Domain.all((Type)DoubleType.DOUBLE)).buildOrThrow());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testNoneColumnWiseUnion() {
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.all(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.none(), (TupleDomain)TupleDomain.none(), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.none());
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.onlyNull((Type)BigintType.BIGINT))), (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.notNull((Type)BigintType.BIGINT))), (TupleDomain[])new TupleDomain[0]), (Object)TupleDomain.all());
    }

    @Test
    public void testMismatchedColumnWiseUnion() {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))));
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)true), (Object)C, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        TupleDomain expectedTupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE)));
        Assert.assertEquals((Object)TupleDomain.columnWiseUnion((TupleDomain)tupleDomain1, (TupleDomain)tupleDomain2, (TupleDomain[])new TupleDomain[0]), (Object)expectedTupleDomain);
    }

    @Test
    public void testOverlaps() {
        TupleDomain emptyTupleDomain = TupleDomain.withColumnDomains(Map.of(A, Domain.create((ValueSet)ValueSet.copyOf((Type)BigintType.BIGINT, List.of()), (boolean)false)));
        Assertions.assertThat((boolean)emptyTupleDomain.overlaps(emptyTupleDomain)).isEqualTo(false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of(), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)), false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)), false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)), false);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)), true);
        this.verifyOverlaps((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)), true);
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertFalse((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2")))));
        Assert.assertTrue((boolean)this.contains((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)Domain.none((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of()));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of(), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)C, (Object)Domain.none((Type)DoubleType.DOUBLE)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.none((Type)VarcharType.VARCHAR))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)DoubleType.DOUBLE)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertTrue((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)C, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)C, (Object)Domain.all((Type)DoubleType.DOUBLE))));
        Assert.assertFalse((boolean)this.equals((Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)VarcharType.VARCHAR)), (Map<ColumnHandle, Domain>)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)C, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0))));
    }

    @Test
    public void testIsNone() {
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.none((Type)BigintType.BIGINT))).isNone());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))).isNone());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT), (Object)B, (Object)Domain.none((Type)BigintType.BIGINT))).isNone());
    }

    @Test
    public void testIsAll() {
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of()).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isAll());
        Assert.assertTrue((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.all((Type)BigintType.BIGINT))).isAll());
        Assert.assertFalse((boolean)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)B, (Object)Domain.all((Type)BigintType.BIGINT))).isAll());
    }

    @Test
    public void testExtractFixedValues() {
        Assert.assertEquals((Map)((Map)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.all((Type)DoubleType.DOUBLE)).put((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)Domain.onlyNull((Type)BigintType.BIGINT)).put((Object)D, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true)).buildOrThrow())).get()), (Map)ImmutableMap.of((Object)B, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)C, (Object)NullableValue.asNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testExtractFixedValuesFromNone() {
        Assert.assertFalse((boolean)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.none()).isPresent());
    }

    @Test
    public void testExtractFixedValuesFromAll() {
        Assert.assertEquals((Map)((Map)TupleDomain.extractFixedValues((TupleDomain)TupleDomain.all()).get()), (Map)ImmutableMap.of());
    }

    @Test
    public void testSingleValuesMapToDomain() {
        Assert.assertEquals((Object)TupleDomain.fromFixedValues((Map)ImmutableMap.builder().put((Object)A, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)1L)).put((Object)B, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.01)).put((Object)D, (Object)NullableValue.asNull((Type)BooleanType.BOOLEAN)).buildOrThrow()), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)B, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))).put((Object)C, (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.01)).put((Object)D, (Object)Domain.onlyNull((Type)BooleanType.BOOLEAN)).buildOrThrow()));
    }

    @Test
    public void testEmptySingleValuesMapToDomain() {
        Assert.assertEquals((Object)TupleDomain.fromFixedValues((Map)ImmutableMap.of()), (Object)TupleDomain.all());
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(ColumnHandle.class, (JsonDeserializer)new JsonDeserializer<ColumnHandle>(){

            public ColumnHandle deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return (ColumnHandle)new ObjectMapperProvider().get().readValue(jsonParser, TestingColumnHandle.class);
            }
        }).addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        TupleDomain tupleDomain = TupleDomain.all();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
        tupleDomain = TupleDomain.none();
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
        tupleDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)A, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)1L), (Object)B, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR)));
        Assert.assertEquals((Object)tupleDomain, (Object)mapper.readValue(mapper.writeValueAsString((Object)tupleDomain), (TypeReference)new TypeReference<TupleDomain<ColumnHandle>>(){}));
    }

    @Test
    public void testTransformKeys() {
        ImmutableMap domains = ImmutableMap.builder().put((Object)1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)3, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).buildOrThrow();
        TupleDomain domain = TupleDomain.withColumnDomains((Map)domains);
        TupleDomain transformed = domain.transformKeys(Object::toString);
        ImmutableMap expected = ImmutableMap.builder().put((Object)"1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)"2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)"3", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).buildOrThrow();
        Assert.assertEquals((Map)((Map)transformed.getDomains().get()), (Map)expected);
    }

    @Test
    public void testTransformKeysFailsWithNonUniqueMapping() {
        ImmutableMap domains = ImmutableMap.builder().put((Object)1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)3, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).buildOrThrow();
        TupleDomain domain = TupleDomain.withColumnDomains((Map)domains);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> domain.transformKeys(input -> "x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Every argument must have a unique mapping. 2 maps to [ SortedRangeSet[type=bigint, ranges=1, {[2]}] ] and [ SortedRangeSet[type=bigint, ranges=1, {[1]}] ]");
    }

    @Test
    public void testTransformKeysRejectsNull() {
        ImmutableMap domains = ImmutableMap.builder().put((Object)1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)3, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)).buildOrThrow();
        TupleDomain domain = TupleDomain.withColumnDomains((Map)domains);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> domain.transformKeys(input -> input == 2 ? null : input)).isInstanceOf(NullPointerException.class)).hasMessageMatching("mapping function \\S+ returned null for 2");
    }

    @Test
    public void testAsPredicate() {
        NullableValue doubleNull = NullableValue.asNull((Type)DoubleType.DOUBLE);
        NullableValue doubleZero = NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.0);
        NullableValue doubleOne = NullableValue.of((Type)DoubleType.DOUBLE, (Object)1.0);
        ValueSet doublePositiveValues = ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]);
        TupleDomain aJustZero = TupleDomain.withColumnDomains(Map.of(A, Domain.singleValue((Type)DoubleType.DOUBLE, (Object)0.0)));
        TupleDomain aJustNull = TupleDomain.withColumnDomains(Map.of(A, Domain.onlyNull((Type)DoubleType.DOUBLE)));
        TupleDomain aZeroAndNull = TupleDomain.withColumnDomains(Map.of(A, Domain.create((ValueSet)ValueSet.of((Type)DoubleType.DOUBLE, (Object)0.0, (Object[])new Object[0]), (boolean)true)));
        TupleDomain aPositive = TupleDomain.withColumnDomains(Map.of(A, Domain.create((ValueSet)doublePositiveValues, (boolean)false)));
        TupleDomain bPositive = TupleDomain.withColumnDomains(Map.of(B, Domain.create((ValueSet)doublePositiveValues, (boolean)false)));
        TupleDomain abPositive = TupleDomain.withColumnDomains(Map.of(A, Domain.create((ValueSet)doublePositiveValues, (boolean)false), B, Domain.create((ValueSet)doublePositiveValues, (boolean)false)));
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.all(), Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.all(), Map.of(A, doubleZero), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.all(), Map.of(A, doubleNull), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.none(), Map.of(), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.none(), Map.of(A, doubleZero), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)TupleDomain.none(), Map.of(A, doubleNull), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustZero, Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustNull, Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aPositive, Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)bPositive, Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)abPositive, Map.of(), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustZero, Map.of(A, doubleZero), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustZero, Map.of(A, doubleNull), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustNull, Map.of(A, doubleZero), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aJustNull, Map.of(A, doubleNull), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aZeroAndNull, Map.of(A, doubleZero), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aZeroAndNull, Map.of(A, doubleNull), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aPositive, Map.of(A, doubleZero), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)aPositive, Map.of(A, doubleNull), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)bPositive, Map.of(A, doubleZero), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)bPositive, Map.of(A, doubleNull), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)abPositive, Map.of(B, doubleZero, C, doubleOne), false);
        this.testAsPredicate((TupleDomain<ColumnHandle>)abPositive, Map.of(B, doubleOne, C, doubleOne), true);
        this.testAsPredicate((TupleDomain<ColumnHandle>)abPositive, Map.of(B, doubleOne, C, doubleZero), true);
    }

    private void testAsPredicate(TupleDomain<ColumnHandle> tupleDomain, Map<ColumnHandle, NullableValue> bindings, boolean expected) {
        Predicate predicate = tupleDomain.asPredicate();
        boolean result = predicate.test(bindings);
        if (result != expected) {
            Assert.fail((String)String.format("asPredicate(%s).test(%s) returned %s instead of %s", tupleDomain, bindings, result, expected));
        }
    }

    private void verifyOverlaps(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2, boolean expected) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDomain2 = TupleDomain.withColumnDomains(domains2);
        Assertions.assertThat((boolean)tupleDomain1.overlaps(tupleDomain2)).isEqualTo(expected);
        Assertions.assertThat((boolean)tupleDomain2.overlaps(tupleDomain1)).isEqualTo(expected);
        Assertions.assertThat((boolean)tupleDomain1.intersect(tupleDomain2).isNone()).isEqualTo(!expected);
    }

    private boolean contains(Map<ColumnHandle, Domain> superSet, Map<ColumnHandle, Domain> subSet) {
        TupleDomain superSetTupleDomain = TupleDomain.withColumnDomains(superSet);
        TupleDomain subSetTupleDomain = TupleDomain.withColumnDomains(subSet);
        boolean contains = superSetTupleDomain.contains(subSetTupleDomain);
        Assertions.assertThat((boolean)contains).isEqualTo(TestTupleDomain.containsFromUnion((TupleDomain<ColumnHandle>)superSetTupleDomain, (TupleDomain<ColumnHandle>)subSetTupleDomain));
        return contains;
    }

    private static boolean containsFromUnion(TupleDomain<ColumnHandle> superSetTupleDomain, TupleDomain<ColumnHandle> subSetTupleDomain) {
        return subSetTupleDomain.isNone() || TupleDomain.columnWiseUnion(superSetTupleDomain, subSetTupleDomain, (TupleDomain[])new TupleDomain[0]).equals(superSetTupleDomain);
    }

    private boolean equals(Map<ColumnHandle, Domain> domains1, Map<ColumnHandle, Domain> domains2) {
        TupleDomain tupleDomain1 = TupleDomain.withColumnDomains(domains1);
        TupleDomain tupleDOmain2 = TupleDomain.withColumnDomains(domains2);
        return tupleDomain1.equals((Object)tupleDOmain2);
    }
}

