/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSortedRangeSet {
    @Test
    public void testEmptySet() {
        SortedRangeSet rangeSet = SortedRangeSet.none((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)rangeSet.getOrderedRanges().isEmpty());
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)0);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)rangeSet.containsValue((Object)0L));
        Assert.assertEquals((String)rangeSet.toString(), (String)"SortedRangeSet[type=bigint, ranges=0, {}]");
    }

    @Test
    public void testEntireSet() {
        SortedRangeSet rangeSet = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertTrue((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)0L));
        Assert.assertEquals((String)rangeSet.toString(), (String)"SortedRangeSet[type=bigint, ranges=1, {(<min>,<max>)}]");
    }

    @Test
    public void testSingleValue() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)10L, (Object[])new Object[0]);
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertTrue((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)10L))));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)10L));
        Assert.assertFalse((boolean)rangeSet.containsValue((Object)9L));
        Assert.assertEquals((String)rangeSet.toString(), (String)"SortedRangeSet[type=bigint, ranges=1, {[10]}]");
        Assert.assertEquals((String)SortedRangeSet.of((Range)Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"LARGE PLATED NICKEL")), (Range[])new Range[0]).toString(), (String)"SortedRangeSet[type=varchar, ranges=1, {[LARGE PLATED NICKEL]}]");
    }

    @Test
    public void testBoundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false), Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)false, (Object)5L, (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)5L, (boolean)true), (Object)Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)false, (Object)9L, (boolean)false), Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)11L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)0L));
        Assert.assertFalse((boolean)rangeSet.containsValue((Object)1L));
        Assert.assertFalse((boolean)rangeSet.containsValue((Object)7L));
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)9L));
        Assert.assertEquals((String)rangeSet.toString(), (String)"SortedRangeSet[type=bigint, ranges=3, {[0], [2,5], [9,11)}]");
        Assert.assertEquals((String)rangeSet.toString((ConnectorSession)ToStringSession.INSTANCE, 2), (String)"SortedRangeSet[type=bigint, ranges=3, {[0], ..., [9,11)}]");
        Assert.assertEquals((String)rangeSet.toString((ConnectorSession)ToStringSession.INSTANCE, 1), (String)"SortedRangeSet[type=bigint, ranges=3, {[0], ...}]");
    }

    @Test
    public void testUnboundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)false, (Object)11L, (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)9L));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)9L, (boolean)true)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)0L));
        Assert.assertTrue((boolean)rangeSet.containsValue((Object)4L));
        Assert.assertFalse((boolean)rangeSet.containsValue((Object)7L));
        Assert.assertEquals((String)rangeSet.toString(), (String)"SortedRangeSet[type=bigint, ranges=3, {(<min>,0], (1,6), (9,<max>)}]");
    }

    @Test
    public void testCreateWithRanges() {
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)5L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.all((Type)BigintType.BIGINT).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("SortedRangeSet does not have just a single value");
    }

    @Test
    public void testSpan() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.none((Type)BigintType.BIGINT).getSpan()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot get span if no ranges exist");
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSpan(), (Object)Range.equal((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)1L, (boolean)true));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        SortedRangeSet valueSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]);
        Assert.assertTrue((boolean)valueSet.contains((ValueSet)valueSet));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Range rangeA = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true);
        Range rangeB = Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)true);
        Range rangeC = Range.range((Type)BigintType.BIGINT, (Object)8L, (boolean)true, (Object)10L, (boolean)true);
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB}).contains((ValueSet)SortedRangeSet.of((Range)rangeC, (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)rangeB, (Range[])new Range[]{rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeA, (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[]{rangeC})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeA, (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeC, (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)6L), Range.equal((Type)BigintType.BIGINT, (Object)9L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)10L, (boolean)true)})));
    }

    @Test
    public void testContainsValue() {
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)BigintType.BIGINT)).containsValue(Long.MIN_VALUE).containsValue(0L).containsValue(42L).containsValue(Long.MAX_VALUE);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)41L, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9L).containsValue(10L).containsValue(11L).containsValue(30L).containsValue(41L).doesNotContainValue(42L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)41L, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10L).containsValue(11L).containsValue(40L).doesNotContainValue(41L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)RealType.REAL)).containsValue(Float.floatToRawIntBits(42.0f)).containsValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)true, (Object)Float.floatToRawIntBits(41.0f), (boolean)true), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(9.999999f)).containsValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(41.00001f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)false, (Object)Float.floatToRawIntBits(41.0f), (boolean)false), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(10.00001f)).containsValue(Float.floatToRawIntBits(40.99999f)).doesNotContainValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)DoubleType.DOUBLE)).containsValue(42.0).containsValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)true, (Object)41.0, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9.999999999999998).containsValue(10.0).containsValue(41.0).doesNotContainValue(41.00000000000001).doesNotContainValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)false, (Object)41.0, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10.0).containsValue(10.00000000000001).containsValue(40.99999999999999).doesNotContainValue(41.0).doesNotContainValue(Double.NaN);
    }

    @Test
    public void testContainsValueRejectNull() {
        SortedRangeSet all = SortedRangeSet.all((Type)BigintType.BIGINT);
        SortedRangeSet none = SortedRangeSet.none((Type)BigintType.BIGINT);
        SortedRangeSet someRange = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)41L, (boolean)false), (Range[])new Range[0]);
        Assertions.assertThatThrownBy(() -> all.containsValue(null)).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> none.containsValue(null)).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> someRange.containsValue(null)).hasMessage("value is null");
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)3L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)false, (Object)4L, (boolean)false)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)-1L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)-1L, (boolean)true, (Object)1L, (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testUnion() {
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)3L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all((Type)BigintType.BIGINT), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)10L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)9L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)10L, (boolean)false), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED NICKEL")), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]));
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        SortedRangeSet set = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.none((Type)DoubleType.DOUBLE);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"), (Object[])new Object[0]);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[]{Range.equal((Type)BooleanType.BOOLEAN, (Object)false)});
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
    }

    @DataProvider
    public Object[][] denseTypes() {
        return new Object[][]{{BigintType.BIGINT}, {IntegerType.INTEGER}, {SmallintType.SMALLINT}, {TinyintType.TINYINT}, {DecimalType.createDecimalType((int)2)}};
    }

    @Test(dataProvider="denseTypes")
    public void testExpandRangesForDenseType(Type type) {
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(0)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.none((Type)type).tryExpandRanges(0)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        Assertions.assertThat((Optional)ValueSet.of((Type)type, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        type.getRange().ifPresent(range -> {
            long min = (Long)range.getMin();
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)min, (boolean)true, (Object)(min + 3L), (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)(min + 4L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)(min + 3L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
            long max = (Long)range.getMax();
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)(max - 3L), (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)(max - 4L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)(max - 3L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
        });
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)6L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)6L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)2L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)3L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L))));
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.of((Type)type, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}).tryExpandRanges(3)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assert.assertEquals((Object)first.union((ValueSet)second), (Object)expected);
        Assert.assertEquals((Object)first.union((Collection)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }

    private static SortedRangeSetAssert assertSortedRangeSet(SortedRangeSet sortedRangeSet) {
        return (SortedRangeSetAssert)Assertions.assertThat(() -> new SortedRangeSetAssert(sortedRangeSet));
    }

    private static class SortedRangeSetAssert {
        private final SortedRangeSet sortedRangeSet;

        public SortedRangeSetAssert(SortedRangeSet sortedRangeSet) {
            this.sortedRangeSet = Objects.requireNonNull(sortedRangeSet, "sortedRangeSet is null");
        }

        public SortedRangeSetAssert containsValue(Object value) {
            if (!this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }

        public SortedRangeSetAssert doesNotContainValue(Object value) {
            if (this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s not to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }
    }
}

