/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.trino.jmh.Benchmarks;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.annotations.Test;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSortedRangeSet {
    @Benchmark
    public SortedRangeSet benchmarkBuilder(Data data) {
        return SortedRangeSet.buildFromUnsortedRanges((Type)BigintType.BIGINT, data.ranges);
    }

    @Benchmark
    public List<SortedRangeSet> ofSingleRange(Data data) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(data.ranges.size());
        for (Range range : data.ranges) {
            ValueSet valueSet = ValueSet.ofRanges((Range)range, (Range[])new Range[0]);
            result.add((SortedRangeSet)valueSet);
        }
        return result;
    }

    @Benchmark
    public List<Boolean> equalsSmall(Data data) {
        return this.benchmarkEquals(data.smallRanges);
    }

    @Benchmark
    public List<Boolean> equalsLarge(Data data) {
        return this.benchmarkEquals(data.largeRanges);
    }

    private List<Boolean> benchmarkEquals(List<SortedRangeSet> dataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).equals((Object)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<SortedRangeSet> unionSmall(Data data) {
        return this.benchmarkUnion(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> unionLarge(Data data) {
        return this.benchmarkUnion(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkUnion(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).union((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<Boolean> overlapsSmall(Data data) {
        return this.benchmarkOverlaps(data.smallRanges);
    }

    @Benchmark
    public List<Boolean> overlapsLarge(Data data) {
        return this.benchmarkOverlaps(data.largeRanges);
    }

    private List<Boolean> benchmarkOverlaps(List<SortedRangeSet> dataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).overlaps((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<ValueSet> intersectSmall(Data data) {
        return this.benchmarkIntersect(data.smallRanges);
    }

    @Benchmark
    public List<ValueSet> intersectLarge(Data data) {
        return this.benchmarkIntersect(data.largeRanges);
    }

    private List<ValueSet> benchmarkIntersect(List<SortedRangeSet> dataRanges) {
        ArrayList<ValueSet> result = new ArrayList<ValueSet>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add((ValueSet)dataRanges.get(index).intersect((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public long containsValueSmall(Data data) {
        return this.benchmarkContainsValue(data.smallRanges);
    }

    @Benchmark
    public long containsValueLarge(Data data) {
        return this.benchmarkContainsValue(data.largeRanges);
    }

    private long benchmarkContainsValue(List<SortedRangeSet> dataRanges) {
        int totalChecks = 5000000;
        long testedValuesTo = 10000L;
        long checksPerSet = totalChecks / dataRanges.size();
        long step = testedValuesTo / checksPerSet;
        long found = 0L;
        for (SortedRangeSet dataRange : dataRanges) {
            for (long i = 0L; i < testedValuesTo; i += step) {
                boolean contained = dataRange.containsValue((Object)i);
                if (!contained) continue;
                ++found;
            }
        }
        return found;
    }

    @Benchmark
    public List<SortedRangeSet> complementSmall(Data data) {
        return this.benchmarkComplement(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> complementLarge(Data data) {
        return this.benchmarkComplement(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkComplement(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size());
        for (SortedRangeSet dataRange : dataRanges) {
            result.add(dataRange.complement());
        }
        return result;
    }

    @Benchmark
    public List<Integer> getOrderedRangesSmall(Data data) {
        return this.benchmarkGetOrderedRanges(data.smallRanges);
    }

    @Benchmark
    public List<Integer> getOrderedRangesLarge(Data data) {
        return this.benchmarkGetOrderedRanges(data.largeRanges);
    }

    private List<Integer> benchmarkGetOrderedRanges(List<SortedRangeSet> dataRanges) {
        ArrayList<Integer> result = new ArrayList<Integer>(dataRanges.size());
        for (int index = 0; index < dataRanges.size(); ++index) {
            int hash = 0;
            for (Range orderedRange : dataRanges.get(index).getRanges().getOrderedRanges()) {
                if (!orderedRange.isLowUnbounded()) {
                    hash = hash * 31 + orderedRange.getLowBoundedValue().hashCode();
                }
                if (orderedRange.isHighUnbounded()) continue;
                hash = hash * 31 + orderedRange.getHighBoundedValue().hashCode();
            }
            result.add(hash);
        }
        return result;
    }

    @Test
    public void test() {
        Data data = new Data();
        data.init();
        this.benchmarkBuilder(data);
        this.ofSingleRange(data);
        this.equalsSmall(data);
        this.equalsLarge(data);
        this.unionSmall(data);
        this.unionLarge(data);
        this.overlapsSmall(data);
        this.overlapsLarge(data);
        this.intersectSmall(data);
        this.intersectLarge(data);
        this.containsValueSmall(data);
        this.containsValueLarge(data);
        this.complementSmall(data);
        this.complementLarge(data);
        this.getOrderedRangesSmall(data);
        this.getOrderedRangesLarge(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkSortedRangeSet.class).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public List<Range> ranges;
        public List<SortedRangeSet> smallRanges;
        public List<SortedRangeSet> largeRanges;

        @Setup(value=Level.Iteration)
        public void init() {
            this.ranges = new ArrayList<Range>();
            long factor = 0L;
            for (int i = 0; i < 10000; ++i) {
                long from = ThreadLocalRandom.current().nextLong(100L) + factor * 100L;
                long to = ThreadLocalRandom.current().nextLong(100L) + (factor + 1L) * 100L;
                ++factor;
                this.ranges.add(Range.range((Type)BigintType.BIGINT, (Object)from, (boolean)false, (Object)to, (boolean)false));
            }
            this.smallRanges = this.generateRangeSets(500000, 2);
            this.largeRanges = this.generateRangeSets(5000, 300);
        }

        private List<SortedRangeSet> generateRangeSets(int count, int size) {
            ArrayList<SortedRangeSet> sortedRangeSets = new ArrayList<SortedRangeSet>();
            for (int i = 0; i < count; ++i) {
                sortedRangeSets.add(this.generateRangeSet(size));
            }
            return sortedRangeSets;
        }

        private SortedRangeSet generateRangeSet(int size) {
            ArrayList<Range> selectedRanges = new ArrayList<Range>();
            for (int i = 0; i < size; ++i) {
                selectedRanges.add(this.ranges.get(ThreadLocalRandom.current().nextInt(this.ranges.size())));
            }
            return SortedRangeSet.copyOf((Type)BigintType.BIGINT, selectedRanges);
        }
    }
}

