/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;

public final class TestingSession {
    public static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Optional<String> getSource() {
            return Optional.of("TestSource");
        }

        public ConnectorIdentity getIdentity() {
            return ConnectorIdentity.ofUser((String)"user");
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public Instant getStart() {
            return Instant.ofEpochMilli(0L);
        }

        public Optional<String> getTraceToken() {
            return Optional.empty();
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
    };

    private TestingSession() {
    }
}

