/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RowBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLazyBlock {
    @Test
    public void testListener() {
        ArrayList notifications = new ArrayList();
        LazyBlock lazyBlock = new LazyBlock(1, () -> TestLazyBlock.createSingleValueBlock(1));
        LazyBlock.listenForLoads((Block)lazyBlock, notifications::add);
        Block loadedBlock = lazyBlock.getBlock();
        Assert.assertEquals(notifications, (Collection)ImmutableList.of((Object)loadedBlock));
        loadedBlock = lazyBlock.getBlock();
        Assert.assertEquals(notifications, (Collection)ImmutableList.of((Object)loadedBlock));
    }

    @Test
    public void testNestedListener() {
        ArrayList<Block> actualNotifications = new ArrayList<Block>();
        LazyBlock lazyBlock = new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock);
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        ArrayList<Block> expectedNotifications = new ArrayList<Block>();
        TestLazyBlock.assertNotificationsRecursive(5, (Block)lazyBlock, actualNotifications, expectedNotifications);
    }

    @Test
    public void testLoadedBlockNestedListener() {
        ArrayList actualNotifications = new ArrayList();
        LazyBlock lazyBlock = new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock);
        Block nestedRowBlock = lazyBlock.getBlock();
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        Block loadedBlock = ((LazyBlock)nestedRowBlock.getChildren().get(0)).getBlock();
        Assert.assertEquals(actualNotifications, (Collection)ImmutableList.of((Object)loadedBlock));
    }

    @Test
    public void testNestedGetLoadedBlock() {
        ArrayList actualNotifications = new ArrayList();
        IntArrayBlock arrayBlock = new IntArrayBlock(1, Optional.empty(), new int[]{0});
        LazyBlock lazyArrayBlock = new LazyBlock(1, () -> TestLazyBlock.lambda$testNestedGetLoadedBlock$1((Block)arrayBlock));
        Block dictionaryBlock = DictionaryBlock.create((int)2, (Block)lazyArrayBlock, (int[])new int[]{0, 0});
        LazyBlock lazyBlock = new LazyBlock(2, () -> dictionaryBlock);
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        Block loadedBlock = lazyBlock.getBlock();
        Assertions.assertThat((Object)loadedBlock).isInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((Object)((DictionaryBlock)loadedBlock).getDictionary()).isInstanceOf(LazyBlock.class);
        Assert.assertEquals(actualNotifications, (Collection)ImmutableList.of((Object)loadedBlock));
        Block fullyLoadedBlock = lazyBlock.getLoadedBlock();
        Assertions.assertThat((Object)fullyLoadedBlock).isInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((Object)((DictionaryBlock)fullyLoadedBlock).getDictionary()).isInstanceOf(IntArrayBlock.class);
        Assert.assertEquals(actualNotifications, (Collection)ImmutableList.of((Object)loadedBlock, (Object)arrayBlock));
        Assert.assertTrue((boolean)lazyBlock.isLoaded());
        Assert.assertTrue((boolean)dictionaryBlock.isLoaded());
    }

    private static void assertNotificationsRecursive(int depth, Block lazyBlock, List<Block> actualNotifications, List<Block> expectedNotifications) {
        Assert.assertFalse((boolean)lazyBlock.isLoaded());
        Block loadedBlock = ((LazyBlock)lazyBlock).getBlock();
        expectedNotifications.add(loadedBlock);
        Assert.assertEquals(actualNotifications, expectedNotifications);
        if (loadedBlock instanceof ArrayBlock) {
            long expectedSize = 5L * (long)loadedBlock.getPositionCount();
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)expectedSize);
            Block elementsBlock = (Block)loadedBlock.getChildren().get(0);
            if (depth > 0) {
                TestLazyBlock.assertNotificationsRecursive(depth - 1, elementsBlock, actualNotifications, expectedNotifications);
            }
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)(expectedSize += elementsBlock.getSizeInBytes()));
            return;
        }
        if (loadedBlock instanceof RowBlock) {
            long expectedSize = 5L * (long)loadedBlock.getPositionCount();
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)expectedSize);
            for (Block fieldBlock : loadedBlock.getChildren()) {
                if (depth > 0) {
                    TestLazyBlock.assertNotificationsRecursive(depth - 1, fieldBlock, actualNotifications, expectedNotifications);
                }
                long fieldBlockSize = fieldBlock.getSizeInBytes();
                Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)(expectedSize += fieldBlockSize));
            }
            return;
        }
        throw new IllegalArgumentException("Unexpected loaded block type: " + loadedBlock.getClass().getSimpleName());
    }

    private static Block createSingleValueBlock(int value) {
        return new IntArrayBlock(1, Optional.empty(), new int[]{value});
    }

    private static Block createInfiniteRecursiveRowBlock() {
        return RowBlock.fromFieldBlocks((int)1, Optional.empty(), (Block[])new Block[]{new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock)});
    }

    private static Block createInfiniteRecursiveArrayBlock() {
        return ArrayBlock.fromElementBlock((int)1, Optional.empty(), (int[])new int[]{0, 1}, (Block)new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock));
    }

    private static /* synthetic */ Block lambda$testNestedGetLoadedBlock$1(Block arrayBlock) {
        return arrayBlock;
    }
}

