/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ShortArrayBlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ObjLongConsumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockRetainedSizeBreakdown {
    private static final int EXPECTED_ENTRIES = 100;

    @Test
    public void testArrayBlock() {
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100);
        int i = 0;
        while (i < 100) {
            int value = i++;
            arrayBlockBuilder.buildEntry(elementBuilder -> TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (BlockBuilder)elementBuilder, (Object)TestBlockRetainedSizeBreakdown.castIntegerToObject(value, (Type)BigintType.BIGINT)));
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(arrayBlockBuilder.build(), false);
    }

    @Test
    public void testByteArrayBlock() {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.writeByte((byte)i);
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testDictionaryBlock() {
        Block keyDictionaryBlock = TestBlockRetainedSizeBreakdown.createVariableWidthBlock(100);
        int[] keyIds = new int[100];
        for (int i = 0; i < keyIds.length; ++i) {
            keyIds[i] = i;
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(DictionaryBlock.create((int)100, (Block)keyDictionaryBlock, (int[])keyIds), false);
    }

    @Test
    public void testIntArrayBlock() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 100);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)IntegerType.INTEGER);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testLongArrayBlock() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 100);
        TestBlockRetainedSizeBreakdown.writeEntries(100, (BlockBuilder)blockBuilder, (Type)BigintType.BIGINT);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testRunLengthEncodedBlock() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 1);
        TestBlockRetainedSizeBreakdown.writeEntries(1, (BlockBuilder)blockBuilder, (Type)BigintType.BIGINT);
        TestBlockRetainedSizeBreakdown.checkRetainedSize(RunLengthEncodedBlock.create((Block)blockBuilder.build(), (int)1), false);
    }

    @Test
    public void testShortArrayBlock() {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.writeShort((short)i);
        }
        TestBlockRetainedSizeBreakdown.checkRetainedSize(blockBuilder.build(), false);
    }

    @Test
    public void testVariableWidthBlock() {
        TestBlockRetainedSizeBreakdown.checkRetainedSize(TestBlockRetainedSizeBreakdown.createVariableWidthBlock(100), false);
    }

    @Test
    public void testInt128ArrayBlock() {
        long[] longs = new long[200];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = i;
        }
        Int128ArrayBlock block = new Int128ArrayBlock(100, Optional.empty(), longs);
        TestBlockRetainedSizeBreakdown.checkRetainedSize((Block)block, false);
    }

    private static void checkRetainedSize(Block block, boolean getRegionCreateNewObjects) {
        AtomicLong objectSize = new AtomicLong();
        Object2LongOpenCustomHashMap trackedObjects = new Object2LongOpenCustomHashMap((Hash.Strategy)new ObjectStrategy());
        ObjLongConsumer<Object> consumer = (object, size) -> {
            objectSize.addAndGet(size);
            trackedObjects.addTo(object, 1L);
        };
        block.retainedBytesForEachPart(consumer);
        Assert.assertEquals((long)objectSize.get(), (long)block.getRetainedSizeInBytes());
        Block copyBlock = block.getRegion(0, block.getPositionCount() / 2);
        copyBlock.retainedBytesForEachPart(consumer);
        Assert.assertEquals((long)objectSize.get(), (long)(block.getRetainedSizeInBytes() + copyBlock.getRetainedSizeInBytes()));
        Assert.assertEquals((long)trackedObjects.getLong((Object)block), (long)1L);
        Assert.assertEquals((long)trackedObjects.getLong((Object)copyBlock), (long)1L);
        trackedObjects.remove((Object)block);
        trackedObjects.remove((Object)copyBlock);
        LongIterator longIterator = trackedObjects.values().iterator();
        while (longIterator.hasNext()) {
            long value = (Long)longIterator.next();
            Assert.assertEquals((long)value, (long)(getRegionCreateNewObjects ? 1L : 2L));
        }
    }

    private static void writeEntries(int expectedEntries, BlockBuilder blockBuilder, Type type) {
        for (int i = 0; i < expectedEntries; ++i) {
            TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)TestBlockRetainedSizeBreakdown.castIntegerToObject(i, type));
        }
    }

    private static Object castIntegerToObject(int value, Type type) {
        if (type == IntegerType.INTEGER || type == TinyintType.TINYINT || type == BigintType.BIGINT) {
            return (long)value;
        }
        if (type == VarcharType.VARCHAR) {
            return String.valueOf(value);
        }
        if (type == DoubleType.DOUBLE) {
            return (double)value;
        }
        throw new UnsupportedOperationException();
    }

    private static Block createVariableWidthBlock(int entries) {
        int[] offsets = new int[entries + 1];
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(entries);
        for (int i = 0; i < entries; ++i) {
            dynamicSliceOutput.writeByte(i);
            offsets[i + 1] = dynamicSliceOutput.size();
        }
        return new VariableWidthBlock(entries, dynamicSliceOutput.slice(), offsets, Optional.empty());
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private ObjectStrategy() {
        }

        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object left, Object right) {
            return left == right;
        }
    }
}

