/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayBlockBuilder {
    private static final int THREE_INTS_ENTRY_SIZE = 32;
    private static final int EXPECTED_ENTRY_COUNT = 100;

    @Test
    public void testArrayBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(3200));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, pageBuilderStatus.createBlockBuilderStatus(), 100);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            blockBuilder.buildEntry(elementBuilder -> {
                BigintType.BIGINT.writeLong(elementBuilder, 12L);
                elementBuilder.appendNull();
                BigintType.BIGINT.writeLong(elementBuilder, 34L);
            });
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)100);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }

    @Test
    public void testRetainedSizeInBytes() {
        int expectedEntries = 1000;
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, expectedEntries);
        long initialRetainedSize = arrayBlockBuilder.getRetainedSizeInBytes();
        int i = 0;
        while (i < expectedEntries) {
            int value = i++;
            arrayBlockBuilder.buildEntry(elementBuilder -> BigintType.BIGINT.writeLong(elementBuilder, (long)value));
        }
        Assert.assertTrue((arrayBlockBuilder.getRetainedSizeInBytes() >= (long)(expectedEntries * 8 + SizeOf.instanceSize(LongArrayBlockBuilder.class)) + initialRetainedSize ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWriting() {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100);
        blockBuilder.buildEntry(elementBuilder -> {
            BigintType.BIGINT.writeLong(elementBuilder, 45L);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> blockBuilder.buildEntry(ignore -> {})).isInstanceOf(IllegalStateException.class)).hasMessage("Expected current entry to be closed but was opened");
        });
    }

    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().build(), 0);
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
    }

    private static BlockBuilder blockBuilder() {
        return new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 10);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assert.assertEquals(block.getClass(), ArrayBlock.class);
        } else {
            Assert.assertEquals(block.getClass(), RunLengthEncodedBlock.class);
            Assert.assertEquals(((RunLengthEncodedBlock)block).getValue().getClass(), ArrayBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assert.assertTrue((boolean)block.isNull(0));
        }
    }
}

