/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.jmh.Benchmarks;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkComputePosition {
    private int hashTableSize = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    private long hashcode = ThreadLocalRandom.current().nextLong();

    @Benchmark
    public long computePositionWithFloorMod() {
        return Math.floorMod(this.hashcode, this.hashTableSize);
    }

    @Benchmark
    public long computePositionWithMod() {
        return (int)(this.hashcode & Long.MAX_VALUE) % this.hashTableSize;
    }

    @Benchmark
    public long computePositionWithMask() {
        return (int)this.hashcode & this.hashTableSize - 1;
    }

    @Benchmark
    public long computePositionWithBitShifting() {
        return (int)(Integer.toUnsignedLong(Long.hashCode(this.hashcode)) * (long)this.hashTableSize >> 32);
    }

    @Benchmark
    public long computePositionWithDivision() {
        return (int)(Integer.toUnsignedLong(Long.hashCode(this.hashcode)) * (long)this.hashTableSize / 0x100000000L);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkComputePosition.class).run();
    }
}

