/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import io.airlift.testing.Assertions;
import io.trino.spi.StandardErrorCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStandardErrorCode {
    private static final int EXTERNAL_ERROR_START = 0x1000000;

    @Test
    public void testUnique() {
        HashSet<Integer> codes = new HashSet<Integer>();
        for (StandardErrorCode code : StandardErrorCode.values()) {
            Assert.assertTrue((boolean)codes.add(TestStandardErrorCode.code(code)), (String)("Code already exists: " + code));
        }
        Assert.assertEquals((int)codes.size(), (int)StandardErrorCode.values().length);
    }

    @Test
    public void testReserved() {
        for (StandardErrorCode errorCode : StandardErrorCode.values()) {
            Assertions.assertLessThan((Comparable)Integer.valueOf(TestStandardErrorCode.code(errorCode)), (Comparable)Integer.valueOf(0x1000000));
        }
    }

    @Test
    public void testOrdering() {
        Iterator<StandardErrorCode> iterator = Arrays.asList(StandardErrorCode.values()).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        int previous = TestStandardErrorCode.code(iterator.next());
        while (iterator.hasNext()) {
            StandardErrorCode code = iterator.next();
            int current = TestStandardErrorCode.code(code);
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(current), (Comparable)Integer.valueOf(previous), (String)("Code is out of order: " + code));
            if (code != StandardErrorCode.GENERIC_INTERNAL_ERROR && code != StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES && code != StandardErrorCode.UNSUPPORTED_TABLE_TYPE) {
                Assert.assertEquals((int)current, (int)(previous + 1), (String)("Code is not sequential: " + code));
            }
            previous = current;
        }
    }

    private static int code(StandardErrorCode error) {
        return error.toErrorCode().getCode();
    }
}

