/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarbinaryType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPage {
    @Test
    public void testGetRegion() {
        Page page = new Page(10);
        Assert.assertEquals((int)page.getRegion(5, 5).getPositionCount(), (int)5);
        Assert.assertSame((Object)page.getRegion(0, 10), (Object)page);
    }

    @Test
    public void testGetEmptyRegion() {
        Assert.assertEquals((int)new Page(0).getRegion(0, 0).getPositionCount(), (int)0);
        Assert.assertEquals((int)new Page(10).getRegion(5, 0).getPositionCount(), (int)0);
    }

    @Test
    public void testGetRegionExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Page(0).getRegion(1, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid position 1 and length 1 in page with 0 positions");
    }

    @Test
    public void testGetRegionFromNoColumnPage() {
        Assert.assertEquals((int)new Page(100).getRegion(0, 10).getPositionCount(), (int)10);
    }

    @Test
    public void testSizesForNoColumnPage() {
        Page page = new Page(100);
        Assert.assertEquals((long)page.getSizeInBytes(), (long)0L);
        Assert.assertEquals((long)page.getLogicalSizeInBytes(), (long)0L);
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)Page.INSTANCE_SIZE);
    }

    @Test
    public void testCompactDictionaryBlocks() {
        int positionCount = 100;
        DictionaryId commonSourceId = DictionaryId.randomDictionaryId();
        int commonDictionaryUsedPositions = 20;
        int[] commonDictionaryIds = TestPage.getDictionaryIds(positionCount, commonDictionaryUsedPositions);
        Slice[] dictionaryValues1 = TestPage.createExpectedValues(50);
        Block dictionary1 = TestPage.createSlicesBlock(dictionaryValues1);
        Block commonSourceIdBlock1 = DictionaryBlock.createProjectedDictionaryBlock((int)positionCount, (Block)dictionary1, (int[])commonDictionaryIds, (DictionaryId)commonSourceId);
        BlockBuilder dictionary2 = BigintType.BIGINT.createBlockBuilder(null, dictionary1.getPositionCount());
        for (Slice expectedValue : dictionaryValues1) {
            BigintType.BIGINT.writeLong(dictionary2, (long)expectedValue.length());
        }
        Block commonSourceIdBlock2 = DictionaryBlock.createProjectedDictionaryBlock((int)positionCount, (Block)dictionary2.build(), (int[])commonDictionaryIds, (DictionaryId)commonSourceId);
        int otherDictionaryUsedPositions = 30;
        int[] otherDictionaryIds = TestPage.getDictionaryIds(positionCount, otherDictionaryUsedPositions);
        Block dictionary3 = TestPage.createSlicesBlock(TestPage.createExpectedValues(70));
        Block randomSourceIdBlock = DictionaryBlock.create((int)otherDictionaryIds.length, (Block)dictionary3, (int[])otherDictionaryIds);
        Page page = new Page(new Block[]{commonSourceIdBlock1, randomSourceIdBlock, commonSourceIdBlock2});
        page.compact();
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(0)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(1)).isCompact());
        Assert.assertTrue((boolean)((DictionaryBlock)page.getBlock(2)).isCompact());
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(0)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(1)).getDictionary().getPositionCount(), (int)otherDictionaryUsedPositions);
        Assert.assertEquals((int)((DictionaryBlock)page.getBlock(2)).getDictionary().getPositionCount(), (int)commonDictionaryUsedPositions);
        Assert.assertNotEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(1)).getDictionarySourceId());
        Assert.assertEquals((Object)((DictionaryBlock)page.getBlock(0)).getDictionarySourceId(), (Object)((DictionaryBlock)page.getBlock(2)).getDictionarySourceId());
    }

    @Test
    public void testGetPositions() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block, block}).getPositions(new int[]{0, 1, 1, 1, 2, 5, 5}, 1, 5);
        Assert.assertEquals((int)page.getPositionCount(), (int)5);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)page.getBlock(i).getLong(0, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(1, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(2, 0), (long)1L);
            Assert.assertEquals((long)page.getBlock(i).getLong(3, 0), (long)2L);
            Assert.assertEquals((long)page.getBlock(i).getLong(4, 0), (long)5L);
        }
    }

    @Test
    public void testGetLoadedPage() {
        int entries = 10;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        LazyBlock lazyBlock = TestPage.lazyWrapper(block);
        Page page = new Page(new Block[]{lazyBlock});
        long lazyPageRetainedSize = (long)Page.INSTANCE_SIZE + SizeOf.sizeOf((Object[])new Block[]{block}) + lazyBlock.getRetainedSizeInBytes();
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)lazyPageRetainedSize);
        Page loadedPage = page.getLoadedPage();
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)lazyPageRetainedSize);
        long loadedPageRetainedSize = (long)Page.INSTANCE_SIZE + SizeOf.sizeOf((Object[])new Block[]{block}) + block.getRetainedSizeInBytes();
        Assert.assertEquals((long)loadedPage.getRetainedSizeInBytes(), (long)loadedPageRetainedSize);
        lazyBlock = TestPage.lazyWrapper(block);
        page = new Page(new Block[]{lazyBlock});
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)lazyPageRetainedSize);
        loadedPage = page.getLoadedPage(new int[]{0}, new int[]{0});
        Assert.assertEquals((long)page.getRetainedSizeInBytes(), (long)loadedPageRetainedSize);
        Assert.assertEquals((long)loadedPage.getRetainedSizeInBytes(), (long)loadedPageRetainedSize);
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPage.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    private static int[] getDictionaryIds(int positionCount, int dictionarySize) {
        Preconditions.checkArgument((positionCount > dictionarySize ? 1 : 0) != 0);
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return ids;
    }

    private static Block createSlicesBlock(Slice[] values) {
        VariableWidthBlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 100);
        for (Slice value : values) {
            Verify.verifyNotNull((Object)value);
            VarbinaryType.VARBINARY.writeSlice((BlockBuilder)builder, value);
        }
        return builder.build();
    }
}

